/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxSetError$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.RemoveEmailsOnDestroy;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.method.MailboxHasChildException;
import org.apache.james.jmap.method.MailboxHasMailException;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$MailboxDeletionResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\rt!B+W\u0011\u0003\tg!B2W\u0011\u0003!\u0007\"B6\u0002\t\u0003agaB7\u0002!\u0003\r\nC\u001c\u0004\u0007\u0003\u007f\u000b\u0001)!1\t\u0015\u0005\u001dAA!f\u0001\n\u0003\t\u0019\r\u0003\u0006\u0002\u0018\u0011\u0011\t\u0012)A\u0005\u0003\u000bDaa\u001b\u0003\u0005\u0002\u0005U\u0007\"CA\u001f\t\u0005\u0005I\u0011AAn\u0011%\t)\u0005BI\u0001\n\u0003\ty\u000eC\u0005\u0002d\u0011\t\t\u0011\"\u0011\u0002f!I\u0011q\u000f\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0003#\u0011\u0011!C\u0001\u0003GD\u0011\"a$\u0005\u0003\u0003%\t%!%\t\u0013\u0005}E!!A\u0005\u0002\u0005\u001d\b\"CAV\t\u0005\u0005I\u0011IAv\u0011%\t\t\fBA\u0001\n\u0003\n\u0019\fC\u0005\u00026\u0012\t\t\u0011\"\u0011\u00028\"I\u0011\u0011\u0018\u0003\u0002\u0002\u0013\u0005\u0013q^\u0004\n\u0003g\f\u0011\u0011!E\u0001\u0003k4\u0011\"a0\u0002\u0003\u0003E\t!a>\t\r-$B\u0011\u0001B\b\u0011%\t)\fFA\u0001\n\u000b\n9\fC\u0005\u0003\u0012Q\t\t\u0011\"!\u0003\u0014!I!q\u0003\u000b\u0002\u0002\u0013\u0005%\u0011\u0004\u0005\n\u0005K!\u0012\u0011!C\u0005\u0005O1A\u0001]\u0001Ac\"Q\u0011q\u0001\u000e\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005]!D!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u001ai\u0011)\u001a!C\u0001\u00037A!\"a\t\u001b\u0005#\u0005\u000b\u0011BA\u000f\u0011\u0019Y'\u0004\"\u0001\u0002&!9\u0011Q\u0006\u000e\u0005\u0002\u0005=\u0002\"CA\u001f5\u0005\u0005I\u0011AA \u0011%\t)EGI\u0001\n\u0003\t9\u0005C\u0005\u0002^i\t\n\u0011\"\u0001\u0002`!I\u00111\r\u000e\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003oR\u0012\u0011!C\u0001\u0003sB\u0011\"!!\u001b\u0003\u0003%\t!a!\t\u0013\u0005=%$!A\u0005B\u0005E\u0005\"CAP5\u0005\u0005I\u0011AAQ\u0011%\tYKGA\u0001\n\u0003\ni\u000bC\u0005\u00022j\t\t\u0011\"\u0011\u00024\"I\u0011Q\u0017\u000e\u0002\u0002\u0013\u0005\u0013q\u0017\u0005\n\u0003sS\u0012\u0011!C!\u0003w;\u0011Ba\f\u0002\u0003\u0003E\tA!\r\u0007\u0011A\f\u0011\u0011!E\u0001\u0005gAaa\u001b\u0018\u0005\u0002\tm\u0002\"CA[]\u0005\u0005IQIA\\\u0011%\u0011\tBLA\u0001\n\u0003\u0013i\u0004C\u0005\u0003\u00189\n\t\u0011\"!\u0003D!I!Q\u0005\u0018\u0002\u0002\u0013%!q\u0005\u0004\u0007\u0005\u001f\n\u0001I!\u0015\t\u0015\tMCG!f\u0001\n\u0003\u0011)\u0006\u0003\u0006\u0003^Q\u0012\t\u0012)A\u0005\u0005/Baa\u001b\u001b\u0005\u0002\t}\u0003b\u0002B3i\u0011\u0005!q\r\u0005\b\u0005W\"D\u0011\u0001B7\u0011%\ti\u0004NA\u0001\n\u0003\u0011y\bC\u0005\u0002FQ\n\n\u0011\"\u0001\u0003\u0004\"I\u00111\r\u001b\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003o\"\u0014\u0011!C\u0001\u0003sB\u0011\"!!5\u0003\u0003%\tAa\"\t\u0013\u0005=E'!A\u0005B\u0005E\u0005\"CAPi\u0005\u0005I\u0011\u0001BF\u0011%\tY\u000bNA\u0001\n\u0003\u0012y\tC\u0005\u00022R\n\t\u0011\"\u0011\u00024\"I\u0011Q\u0017\u001b\u0002\u0002\u0013\u0005\u0013q\u0017\u0005\n\u0003s#\u0014\u0011!C!\u0005';\u0011Ba&\u0002\u0003\u0003E\tA!'\u0007\u0013\t=\u0013!!A\t\u0002\tm\u0005BB6G\t\u0003\u0011y\nC\u0005\u00026\u001a\u000b\t\u0011\"\u0012\u00028\"I!\u0011\u0003$\u0002\u0002\u0013\u0005%\u0011\u0015\u0005\n\u0005/1\u0015\u0011!CA\u0005KC\u0011B!\nG\u0003\u0003%IAa\n\u0007\u000b\r4\u0006Aa+\t\u0015\t5FJ!A!\u0002\u0013\u0011y\u000b\u0003\u0006\u000382\u0013\t\u0011)A\u0005\u0005sC!Ba0M\u0005\u0003\u0005\u000b\u0011\u0002Ba\u0011\u0019YG\n\"\u0001\u0003P\"9!1\u001e'\u0005\u0002\t5\bbBB\u0018\u0019\u0012%1\u0011\u0007\u0005\b\u0007\u000fbE\u0011BB%\u0011\u001d\u00199\u0006\u0014C\u0005\u00073\n\u0011$T1jY\n|\u0007pU3u\t\u0016dW\r^3QKJ4wN]7fe*\u0011q\u000bW\u0001\u0007[\u0016$\bn\u001c3\u000b\u0005eS\u0016\u0001\u00026nCBT!a\u0017/\u0002\u000b)\fW.Z:\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0002\u0001!\t\u0011\u0017!D\u0001W\u0005ei\u0015-\u001b7c_b\u001cV\r\u001e#fY\u0016$X\rU3sM>\u0014X.\u001a:\u0014\u0005\u0005)\u0007C\u00014j\u001b\u00059'\"\u00015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)<'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\n)R*Y5mE>DH)\u001a7fi&|gNU3tk2$8CA\u0002fS\r\u0019!\u0004\u0002\u0002\u0017\u001b\u0006LGNY8y\t\u0016dW\r^5p]\u001a\u000b\u0017\u000e\\;sKN)!$\u001a:uoB\u00111oA\u0007\u0002\u0003A\u0011a-^\u0005\u0003m\u001e\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002y\u0003\u0003q!!\u001f@\u000f\u0005ilX\"A>\u000b\u0005q\u0004\u0017A\u0002\u001fs_>$h(C\u0001i\u0013\tyx-A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u007f\u001e\f\u0011\"\\1jY\n|\u00070\u00133\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001,\u0001\u0003nC&d\u0017\u0002BA\u000b\u0003\u001f\u0011\u0011#\u00168qCJ\u001cX\rZ'bS2\u0014w\u000e_%e\u0003)i\u0017-\u001b7c_bLE\rI\u0001\nKb\u001cW\r\u001d;j_:,\"!!\b\u0011\u0007a\fy\"\u0003\u0003\u0002\"\u0005\u0015!!\u0003+ie><\u0018M\u00197f\u0003))\u0007pY3qi&|g\u000e\t\u000b\u0007\u0003O\tI#a\u000b\u0011\u0005MT\u0002bBA\u0004?\u0001\u0007\u00111\u0002\u0005\b\u00033y\u0002\u0019AA\u000f\u0003E\t7/T1jY\n|\u0007pU3u\u000bJ\u0014xN]\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oA\u0016\u0001B2pe\u0016LA!a\u000f\u00026\tA1+\u001a;FeJ|'/\u0001\u0003d_BLHCBA\u0014\u0003\u0003\n\u0019\u0005C\u0005\u0002\b\u0005\u0002\n\u00111\u0001\u0002\f!I\u0011\u0011D\u0011\u0011\u0002\u0003\u0007\u0011QD\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIE\u000b\u0003\u0002\f\u0005-3FAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]s-\u0001\u0006b]:|G/\u0019;j_:LA!a\u0017\u0002R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\r\u0016\u0005\u0003;\tY%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003O\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'\u0001\u0003mC:<'BAA9\u0003\u0011Q\u0017M^1\n\t\u0005U\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0004c\u00014\u0002~%\u0019\u0011qP4\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00151\u0012\t\u0004M\u0006\u001d\u0015bAAEO\n\u0019\u0011I\\=\t\u0013\u00055e%!AA\u0002\u0005m\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0014B1\u0011QSAN\u0003\u000bk!!a&\u000b\u0007\u0005eu-\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0018\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019+!+\u0011\u0007\u0019\f)+C\u0002\u0002(\u001e\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u000e\"\n\t\u00111\u0001\u0002\u0006\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9'a,\t\u0013\u00055\u0015&!AA\u0002\u0005m\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005m\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002$\u0006u\u0006\"CAGY\u0005\u0005\t\u0019AAC\u0005Yi\u0015-\u001b7c_b$U\r\\3uS>t7+^2dKN\u001c8#\u0002\u0003feR<XCAAc!\u0011\t9-!5\u000e\u0005\u0005%'\u0002BAf\u0003\u001b\fQ!\\8eK2T1!a4[\u0003\u001di\u0017-\u001b7c_bLA!a5\u0002J\nIQ*Y5mE>D\u0018\n\u001a\u000b\u0005\u0003/\fI\u000e\u0005\u0002t\t!9\u0011qA\u0004A\u0002\u0005\u0015G\u0003BAl\u0003;D\u0011\"a\u0002\t!\u0003\u0005\r!!2\u0016\u0005\u0005\u0005(\u0006BAc\u0003\u0017\"B!!\"\u0002f\"I\u0011Q\u0012\u0007\u0002\u0002\u0003\u0007\u00111\u0010\u000b\u0005\u0003G\u000bI\u000fC\u0005\u0002\u000e:\t\t\u00111\u0001\u0002\u0006R!\u0011qMAw\u0011%\tiiDA\u0001\u0002\u0004\tY\b\u0006\u0003\u0002$\u0006E\b\"CAG%\u0005\u0005\t\u0019AAC\u0003Yi\u0015-\u001b7c_b$U\r\\3uS>t7+^2dKN\u001c\bCA:\u0015'\u0015!\u0012\u0011 B\u0003!!\tYP!\u0001\u0002F\u0006]WBAA\u007f\u0015\r\typZ\u0001\beVtG/[7f\u0013\u0011\u0011\u0019!!@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\u0011\u0011Y!a\u001c\u0002\u0005%|\u0017\u0002BA\u0002\u0005\u0013!\"!!>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u0005]'Q\u0003\u0005\b\u0003\u000f9\u0002\u0019AAc\u0003\u001d)h.\u00199qYf$BAa\u0007\u0003\"A)aM!\b\u0002F&\u0019!qD4\u0003\r=\u0003H/[8o\u0011%\u0011\u0019\u0003GA\u0001\u0002\u0004\t9.A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u000b\u0011\t\u0005%$1F\u0005\u0005\u0005[\tYG\u0001\u0004PE*,7\r^\u0001\u0017\u001b\u0006LGNY8y\t\u0016dW\r^5p]\u001a\u000b\u0017\u000e\\;sKB\u00111OL\n\u0006]\tU\"Q\u0001\t\u000b\u0003w\u00149$a\u0003\u0002\u001e\u0005\u001d\u0012\u0002\u0002B\u001d\u0003{\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\t\u0004\u0006\u0004\u0002(\t}\"\u0011\t\u0005\b\u0003\u000f\t\u0004\u0019AA\u0006\u0011\u001d\tI\"\ra\u0001\u0003;!BA!\u0012\u0003NA)aM!\b\u0003HA9aM!\u0013\u0002\f\u0005u\u0011b\u0001B&O\n1A+\u001e9mKJB\u0011Ba\t3\u0003\u0003\u0005\r!a\n\u0003-5\u000b\u0017\u000e\u001c2pq\u0012+G.\u001a;j_:\u0014Vm];miN\u001cB\u0001N3uo\u00069!/Z:vYR\u001cXC\u0001B,!\u0011A(\u0011\f:\n\t\tm\u0013Q\u0001\u0002\u0004'\u0016\f\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\t\u0005$1\r\t\u0003gRBqAa\u00158\u0001\u0004\u00119&A\u0005eKN$(o\\=fIV\u0011!\u0011\u000e\t\u0006q\ne\u0013QY\u0001\u000fe\u0016$(/[3wK\u0016\u0013(o\u001c:t+\t\u0011y\u0007\u0005\u0005\u0003r\te\u00141BA\u0019\u001d\u0011\u0011\u0019H!\u001e\u0011\u0005i<\u0017b\u0001B<O\u00061\u0001K]3eK\u001aLAAa\u001f\u0003~\t\u0019Q*\u00199\u000b\u0007\t]t\r\u0006\u0003\u0003b\t\u0005\u0005\"\u0003B*uA\u0005\t\u0019\u0001B,+\t\u0011)I\u000b\u0003\u0003X\u0005-C\u0003BAC\u0005\u0013C\u0011\"!$?\u0003\u0003\u0005\r!a\u001f\u0015\t\u0005\r&Q\u0012\u0005\n\u0003\u001b\u0003\u0015\u0011!a\u0001\u0003\u000b#B!a\u001a\u0003\u0012\"I\u0011QR!\u0002\u0002\u0003\u0007\u00111\u0010\u000b\u0005\u0003G\u0013)\nC\u0005\u0002\u000e\u0012\u000b\t\u00111\u0001\u0002\u0006\u00061R*Y5mE>DH)\u001a7fi&|gNU3tk2$8\u000f\u0005\u0002t\rN)aI!(\u0003\u0006AA\u00111 B\u0001\u0005/\u0012\t\u0007\u0006\u0002\u0003\u001aR!!\u0011\rBR\u0011\u001d\u0011\u0019&\u0013a\u0001\u0005/\"BAa*\u0003*B)aM!\b\u0003X!I!1\u0005&\u0002\u0002\u0003\u0007!\u0011M\n\u0003\u0019\u0016\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0003\u00032\nMVBAAg\u0013\u0011\u0011),!4\u0003\u001d5\u000b\u0017\u000e\u001c2pq6\u000bg.Y4fe\u0006\u00192/\u001e2tGJL\u0007\u000f^5p]6\u000bg.Y4feB!!\u0011\u0017B^\u0013\u0011\u0011i,!4\u0003'M+(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0002!5\f\u0017\u000e\u001c2pq&#g)Y2u_JL\b\u0003\u0002Bb\u0005\u0013tA!a2\u0003F&!!qYAe\u0003%i\u0015-\u001b7c_bLE-\u0003\u0003\u0003L\n5'a\u0002$bGR|'/\u001f\u0006\u0005\u0005\u000f\fI\r\u0006\u0005\u0003R\nM'Q\u001bBl!\t\u0011G\nC\u0004\u0003.B\u0003\rAa,\t\u000f\t]\u0006\u000b1\u0001\u0003:\"9!q\u0018)A\u0002\t\u0005\u0007f\u0001)\u0003\\B!!Q\u001cBt\u001b\t\u0011yN\u0003\u0003\u0003b\n\r\u0018AB5oU\u0016\u001cGO\u0003\u0002\u0003f\u0006)!.\u0019<bq&!!\u0011\u001eBp\u0005\u0019IeN[3di\u0006yA-\u001a7fi\u0016l\u0015-\u001b7c_b,7\u000f\u0006\u0004\u0003p\u000em1Q\u0005\t\u0007\u0005c\u0014ypa\u0001\u000e\u0005\tM(\u0002\u0002B{\u0005o\f\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007!\u0014IP\u0003\u0003\u00028\tm(B\u0001B\u007f\u0003\u001d\u0011X-Y2u_JLAa!\u0001\u0003t\n)1+T8o_B\u00191Q\u0001\u001b\u000f\u0007\r\u001d\u0001A\u0004\u0003\u0004\n\rea\u0002BB\u0006\u0007/qAa!\u0004\u0004\u00169!1qBB\n\u001d\rQ8\u0011C\u0005\u0002?&\u0011QLX\u0005\u00037rK!!\u0017.\n\u0005]C\u0006bBB\u000f#\u0002\u00071qD\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\u0011\tl!\t\n\t\r\r\u0012Q\u001a\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0011\u001d\u00199#\u0015a\u0001\u0007S\t\u0011#\\1jY\n|\u0007pU3u%\u0016\fX/Z:u!\u0011\tiaa\u000b\n\t\r5\u0012q\u0002\u0002\u0012\u001b\u0006LGNY8y'\u0016$(+Z9vKN$\u0018A\u00023fY\u0016$X\r\u0006\u0005\u00044\r]2\u0011HB\u001f!\u0019\u0011\tPa@\u00046A\u00191QA\u0002\t\u000f\ru!\u000b1\u0001\u0004 !911\b*A\u0002\u0005-\u0011AA5e\u0011\u001d\u0019yD\u0015a\u0001\u0007\u0003\n\u0011b\u001c8EKN$(o\\=\u0011\t\u0005511I\u0005\u0005\u0007\u000b\nyAA\u000bSK6|g/Z#nC&d7o\u00148EKN$(o\\=\u0002\u0011\u0011|G)\u001a7fi\u0016$\u0002ba\u0013\u0004R\rM3Q\u000b\t\u0004M\u000e5\u0013bAB(O\n!QK\\5u\u0011\u001d\u0019ib\u0015a\u0001\u0007?Aqaa\u000fT\u0001\u0004\t)\rC\u0004\u0004@M\u0003\ra!\u0011\u0002!%\u001c\u0018iU=ti\u0016lW*Y5mE>DH\u0003BAR\u00077Bq!a4U\u0001\u0004\u0019i\u0006\u0005\u0003\u00032\u000e}\u0013\u0002BB1\u0003\u001b\u0014a\"T3tg\u0006<W-T1oC\u001e,'\u000f")
public class MailboxSetDeletePerformer {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxDeletionResults> deleteMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.destroy().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> this.delete(mailboxSession, (UnparsedMailboxId)id, ((RemoveEmailsOnDestroy)mailboxSetRequest.onDestroyRemoveEmails().getOrElse((Function0 & Serializable)() -> new RemoveEmailsOnDestroy(MailboxSetDeletePerformer.$anonfun$deleteMailboxes$3()))).value()).onErrorRecover((PartialFunction)new Serializable(null, (UnparsedMailboxId)id){
            private static final long serialVersionUID = 0L;
            private final UnparsedMailboxId id$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                MailboxDeletionFailure mailboxDeletionFailure = new MailboxDeletionFailure(this.id$1, e);
                return (B1)mailboxDeletionFailure;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                boolean bl = true;
                return bl;
            }
            {
                this.id$1 = id$1;
            }
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetDeletePerformer$MailboxDeletionResults$.MODULE$);
    }

    private SMono<MailboxDeletionResult> delete(MailboxSession mailboxSession, UnparsedMailboxId id2, boolean onDestroy) {
        return (SMono)MailboxGet$.MODULE$.parse(this.mailboxIdFactory, id2).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)id -> SMono$.MODULE$.fromCallable(() -> {
            this.doDelete(mailboxSession, id, onDestroy);
            return BoxedUnit.UNIT;
        }).subscribeOn(Schedulers.elastic()).then(SMono$.MODULE$.just((Object)new MailboxDeletionSuccess((MailboxId)id))));
    }

    private void doDelete(MailboxSession mailboxSession, MailboxId id, boolean onDestroy) {
        MessageManager mailbox = this.mailboxManager.getMailbox(id, mailboxSession);
        if (this.isASystemMailbox(mailbox)) {
            throw new SystemMailboxChangeException(id);
        }
        if (this.mailboxManager.hasChildren(mailbox.getMailboxPath(), mailboxSession)) {
            throw new MailboxHasChildException(id);
        }
        if (onDestroy) {
            Mailbox deletedMailbox = this.mailboxManager.deleteMailbox(id, mailboxSession);
            this.subscriptionManager.unsubscribe(mailboxSession, deletedMailbox.getName());
        } else {
            if (mailbox.getMessages(MessageRange.all(), FetchGroup.MINIMAL, mailboxSession).hasNext()) {
                throw new MailboxHasMailException(id);
            }
            Mailbox deletedMailbox = this.mailboxManager.deleteMailbox(id, mailboxSession);
            this.subscriptionManager.unsubscribe(mailboxSession, deletedMailbox.getName());
        }
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteMailboxes$3() {
        return false;
    }

    @Inject
    public MailboxSetDeletePerformer(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxDeletionFailure
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            SetError setError;
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                setError = SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            } else if (throwable instanceof MailboxHasMailException) {
                MailboxHasMailException mailboxHasMailException = (MailboxHasMailException)throwable;
                setError = MailboxSetError$.MODULE$.mailboxHasEmail(new StringBuilder(13).append(mailboxHasMailException.mailboxId().serialize()).append(" is not empty").toString());
            } else if (throwable instanceof MailboxHasChildException) {
                MailboxHasChildException mailboxHasChildException = (MailboxHasChildException)throwable;
                setError = MailboxSetError$.MODULE$.mailboxHasChild(new StringBuilder(20).append(mailboxHasChildException.mailboxId().serialize()).append(" has child mailboxes").toString());
            } else if (throwable instanceof SystemMailboxChangeException) {
                setError = SetError$.MODULE$.invalidArguments("System mailboxes cannot be destroyed", SetError$.MODULE$.invalidArguments$default$2());
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                setError = SetError$.MODULE$.invalidArguments(new StringBuilder(21).append(new Refined((Object)this.mailboxId().id())).append(" is not a mailboxId: ").append(illegalArgumentException.getMessage()).toString(), SetError$.MODULE$.invalidArguments$default$2());
            } else {
                setError = SetError$.MODULE$.serverFail(this.exception().getMessage());
            }
            return setError;
        }

        public MailboxDeletionFailure copy(UnparsedMailboxId mailboxId, Throwable exception) {
            return new MailboxDeletionFailure(mailboxId, exception);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxDeletionFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxId();
                    break;
                }
                case 1: {
                    object = this.exception();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                case 1: {
                    string2 = "exception";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxDeletionFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxDeletionFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!mailboxDeletionFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionFailure(UnparsedMailboxId mailboxId, Throwable exception) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxDeletionResult {
    }

    public static class MailboxDeletionResults
    implements Product,
    Serializable {
        private final Seq<MailboxDeletionResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxDeletionResult> results() {
            return this.results;
        }

        public Seq<MailboxId> destroyed() {
            return (Seq)((IterableOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionSuccess) {
                    MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)mailboxDeletionResult;
                    none$ = new Some((Object)mailboxDeletionSuccess);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).map((Function1 & Serializable)x$1 -> x$1.mailboxId());
        }

        public Map<UnparsedMailboxId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionFailure) {
                    MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)mailboxDeletionResult;
                    none$ = new Some((Object)new Tuple2((Object)mailboxDeletionFailure.mailboxId(), (Object)mailboxDeletionFailure.asMailboxSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxDeletionResults copy(Seq<MailboxDeletionResult> results) {
            return new MailboxDeletionResults(results);
        }

        public Seq<MailboxDeletionResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxDeletionResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.results();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "results";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionResults mailboxDeletionResults = (MailboxDeletionResults)x$1;
            Seq<MailboxDeletionResult> seq = this.results();
            Seq<MailboxDeletionResult> seq2 = mailboxDeletionResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxDeletionResults.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionResults(Seq<MailboxDeletionResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxDeletionSuccess
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxDeletionSuccess copy(MailboxId mailboxId) {
            return new MailboxDeletionSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxDeletionSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxId";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxDeletionSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxDeletionSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

