/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.change.VacationResponseTypeName$;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.VacationSerializer$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.VacationResponseSetMethod$;
import org.apache.james.jmap.method.VacationResponseUpdateFailure;
import org.apache.james.jmap.method.VacationResponseUpdateResult;
import org.apache.james.jmap.method.VacationResponseUpdateResults;
import org.apache.james.jmap.method.VacationResponseUpdateResults$;
import org.apache.james.jmap.method.VacationResponseUpdateSuccess$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.vacation.VacationResponsePatchObject;
import org.apache.james.jmap.vacation.VacationResponseSetError;
import org.apache.james.jmap.vacation.VacationResponseSetError$;
import org.apache.james.jmap.vacation.VacationResponseSetRequest;
import org.apache.james.jmap.vacation.VacationResponseSetResponse;
import org.apache.james.jmap.vacation.VacationResponseUpdateResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationService;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\teq!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007w\u0005\u0001\u000b\u0011B\u001a\u0007\t\u001dR\u0002\u0001\u0010\u0005\t\r\u0016\u0011\t\u0011)A\u0005\u000f\"A\u0011,\u0002B\u0001B\u0003%!\f\u0003\u0005b\u000b\t\u0015\r\u0011\"\u0001c\u0011!QWA!A!\u0002\u0013\u0019\u0007\u0002C6\u0006\u0005\u000b\u0007I\u0011\u00017\t\u0011M,!\u0011!Q\u0001\n5DQaL\u0003\u0005\u0002QD\u0001b`\u0003C\u0002\u0013\u0005\u0013\u0011\u0001\u0005\t\u0003_)\u0001\u0015!\u0003\u0002\u0004!I\u0011\u0011G\u0003C\u0002\u0013\u0005\u00131\u0007\u0005\t\u0003'*\u0001\u0015!\u0003\u00026!9\u0011QK\u0003\u0005B\u0005]\u0003bBAH\u000b\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003o+A\u0011BA]\u0011\u001d\t9,\u0002C\u0005\u0003\u0013Dq!a8\u0006\t\u0013\t\t\u000fC\u0004\u0002l\u0016!I!!<\t\u000f\u0005]X\u0001\"\u0003\u0002z\"9!1C\u0003\u0005\n\tU\u0011!\u0007,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f'\u0016$X*\u001a;i_\u0012T!a\u0007\u000f\u0002\r5,G\u000f[8e\u0015\tib$\u0001\u0003k[\u0006\u0004(BA\u0010!\u0003\u0015Q\u0017-\\3t\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001A\u0011a%A\u0007\u00025\tIb+Y2bi&|gNU3ta>t7/Z*fi6+G\u000f[8e'\t\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\n!EV!D\u0003RKuJT0S\u000bN\u0003vJT*F?B\u000bEk\u0011%`\u001f\nSUi\u0011+`\u0017\u0016KV#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\f1EV!D\u0003RKuJT0S\u000bN\u0003vJT*F?B\u000bEk\u0011%`\u001f\nSUi\u0011+`\u0017\u0016K\u0006eE\u0002\u0006Su\u00022A\n A\u0013\ty$D\u0001\rNKRDw\u000e\u001a*fcVL'/\u001b8h\u0003\u000e\u001cw.\u001e8u\u0013\u0012\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u000f\u0002\u0011Y\f7-\u0019;j_:L!!\u0012\"\u00035Y\u000b7-\u0019;j_:\u0014Vm\u001d9p]N,7+\u001a;SKF,Xm\u001d;\u0002\u0011\u00154XM\u001c;CkN\u0004\"\u0001S&\u000e\u0003%S!A\u0013\u0010\u0002\r\u00154XM\u001c;t\u0013\ta\u0015J\u0001\u0005Fm\u0016tGOQ;tQ\u00111aJV,\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016AB5oU\u0016\u001cGOC\u0001T\u0003\u0015Q\u0017M^1y\u0013\t)\u0006KA\u0003OC6,G-A\u0003wC2,X-I\u0001Y\u0003\u0011QU*\u0011)\u0002\u001fY\f7-\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"aW0\u000e\u0003qS!!\u00180\u0002\u0007\u0005\u0004\u0018N\u0003\u0002D=%\u0011\u0001\r\u0018\u0002\u0010-\u0006\u001c\u0017\r^5p]N+'O^5dK\u0006iQ.\u001a;sS\u000e4\u0015m\u0019;pef,\u0012a\u0019\t\u0003I\"l\u0011!\u001a\u0006\u0003;\u001aT!a\u001a\u0010\u0002\u000f5,GO]5dg&\u0011\u0011.\u001a\u0002\u000e\u001b\u0016$(/[2GC\u000e$xN]=\u0002\u001d5,GO]5d\r\u0006\u001cGo\u001c:zA\u0005y1/Z:tS>t7+\u001e9qY&,'/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001H$\u0001\u0004s_V$Xm]\u0005\u0003e>\u0014qbU3tg&|gnU;qa2LWM]\u0001\u0011g\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0002\"R!\u001e<ysj\u0004\"AJ\u0003\t\u000b\u0019c\u0001\u0019A$)\tYtek\u0016\u0005\u000632\u0001\rA\u0017\u0005\u0006C2\u0001\ra\u0019\u0005\u0006W2\u0001\r!\u001c\u0015\u0003\u0019q\u0004\"aT?\n\u0005y\u0004&AB%oU\u0016\u001cG/\u0001\u0006nKRDw\u000e\u001a(b[\u0016,\"!a\u0001\u0011\t\u0005\u0015\u0011\u0011\u0006\b\u0005\u0003\u000f\t\u0019C\u0004\u0003\u0002\n\u0005}a\u0002BA\u0006\u0003;qA!!\u0004\u0002\u001c9!\u0011qBA\r\u001d\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bI\u00051AH]8pizJ\u0011aI\u0005\u0003C\tJ!a\b\u0011\n\u0005uq\u0012bAA\u00119\u0005!1m\u001c:f\u0013\u0011\t)#a\n\u0002\u0015%sgo\\2bi&|gNC\u0002\u0002\"qIA!a\u000b\u0002.\tQQ*\u001a;i_\u0012t\u0015-\\3\u000b\t\u0005\u0015\u0012qE\u0001\f[\u0016$\bn\u001c3OC6,\u0007%\u0001\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm]\u000b\u0003\u0003k\u0001b!a\u000e\u0002@\u0005\u0015c\u0002BA\u001d\u0003w\u00012!!\u0005,\u0013\r\tidK\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0004'\u0016$(bAA\u001fWA!\u0011qIA'\u001d\u0011\t9!!\u0013\n\t\u0005-\u0013qE\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\u0005=\u0013\u0011\u000b\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\t\u0005-\u0013qE\u0001\u0016e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:!\u0003%!w\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0006\u0002Z\u0005M\u0014qOA>\u0003\u0017\u0003b!a\u0017\u0002j\u00055TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u0017\u0002d)!\u0011\u0011EA3\u0015\t\t9'A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005-\u0014Q\f\u0002\u0006'6{gn\u001c\t\u0004M\u0005=\u0014bAA95\t)\u0012J\u001c<pG\u0006$\u0018n\u001c8XSRD7i\u001c8uKb$\bbBA;#\u0001\u0007\u0011QG\u0001\rG\u0006\u0004\u0018MY5mSRLWm\u001d\u0005\b\u0003s\n\u0002\u0019AA7\u0003)IgN^8dCRLwN\u001c\u0005\b\u0003{\n\u0002\u0019AA@\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000bs\u0012aB7bS2\u0014w\u000e_\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\t\r\u00055\u0015\u00031\u0001A\u0003\u001d\u0011X-];fgR\f!bZ3u%\u0016\fX/Z:u)\u0019\t\u0019*a+\u0002.B9\u0011QSAP\u0003K\u0003e\u0002BAL\u00037sA!!\u0005\u0002\u001a&\tA&C\u0002\u0002\u001e.\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&AB#ji\",'OC\u0002\u0002\u001e.\u0002B!!&\u0002(&!\u0011\u0011VAR\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0005\b\u0003{\u0012\u0002\u0019AA@\u0011\u001d\tIH\u0005a\u0001\u0003_\u0003B!!-\u000246\u0011\u0011qE\u0005\u0005\u0003k\u000b9C\u0001\u0006J]Z|7-\u0019;j_:\fa!\u001e9eCR,GCBA^\u0003\u0007\f)\r\u0005\u0004\u0002\\\u0005%\u0014Q\u0018\t\u0004M\u0005}\u0016bAAa5\tib+Y2bi&|gNU3ta>t7/Z+qI\u0006$XMU3tk2$8\u000fC\u0004\u0002~M\u0001\r!a \t\r\u0005\u001d7\u00031\u0001A\u0003i1\u0018mY1uS>t'+Z:q_:\u001cXmU3u%\u0016\fX/Z:u)\u0019\tY-a5\u0002^B1\u00111LA5\u0003\u001b\u00042AJAh\u0013\r\t\tN\u0007\u0002\u001d-\u0006\u001c\u0017\r^5p]J+7\u000f]8og\u0016,\u0006\u000fZ1uKJ+7/\u001e7u\u0011\u001d\t)\u000e\u0006a\u0001\u0003/\faB^1mS\u0012\fG/\u001a3QCR\u001c\u0007\u000eE\u0002\\\u00033L1!a7]\u000551\u0016mY1uS>t\u0007+\u0019;dQ\"9\u0011Q\u0010\u000bA\u0002\u0005}\u0014a\u0005;p-\u0006\u001c\u0017\r^5p]\u0006\u001b7m\\;oi&#G\u0003BAr\u0003S\u00042aWAs\u0013\r\t9\u000f\u0018\u0002\n\u0003\u000e\u001cw.\u001e8u\u0013\u0012Dq!! \u0016\u0001\u0004\ty(\u0001\bde\u0016\fG/\u001a*fgB|gn]3\u0015\u0011\u0005=\u0016q^Ay\u0003gDq!!\u001f\u0017\u0001\u0004\ty\u000b\u0003\u0004\u0002HZ\u0001\r\u0001\u0011\u0005\b\u0003k4\u0002\u0019AA_\u00031)\b\u000fZ1uKJ+7/\u001e7u\u0003A1\u0018\r\\5eCR,gj\\\"sK\u0006$X\r\u0006\u0003\u0002|\nE\u0001#\u0002\u0016\u0002~\n\u0005\u0011bAA\u0000W\t1q\n\u001d;j_:\u0004\u0002\"a\u000e\u0003\u0004\t\u001d!1B\u0005\u0005\u0005\u000b\t\u0019EA\u0002NCB\u0004B!a\u000e\u0003\n%\u0019!(a\u0011\u0011\u0007\u0005\u0013i!C\u0002\u0003\u0010\t\u0013\u0001DV1dCRLwN\u001c*fgB|gn]3TKR,%O]8s\u0011\u0019\t9m\u0006a\u0001\u0001\u0006\tb/\u00197jI\u0006$XMT8EKN$(o\\=\u0015\t\u0005m(q\u0003\u0005\u0007\u0003\u000fD\u0002\u0019\u0001!")
public class VacationResponseSetMethod
implements MethodRequiringAccountId<VacationResponseSetRequest> {
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final VacationService vacationService;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    public static String VACATION_RESPONSE_PATCH_OBJECT_KEY() {
        return VacationResponseSetMethod$.MODULE$.VACATION_RESPONSE_PATCH_OBJECT_KEY();
    }

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, VacationResponseSetRequest request) {
        return this.update(mailboxSession, request).map((Function1 & Serializable)updateResult -> this.createResponse(invocation.invocation(), request, (VacationResponseUpdateResults)updateResult)).flatMap((Function1 & Serializable)next -> {
            StateChangeEvent event = new StateChangeEvent(Event.EventId.random(), mailboxSession.getUser(), (Map<TypeName, State>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VacationResponseTypeName$.MODULE$), (Object)UuidState$.MODULE$.fromGenerateUuid())}))));
            AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
            return SMono$.MODULE$.apply((Publisher)$this.eventBus.dispatch((Event)event, (RegistrationKey)new AccountIdRegistrationKey(accountId))).then(SMono$.MODULE$.just(next));
        }).map((Function1 & Serializable)x$1 -> new InvocationWithContext((Invocation)x$1, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, VacationResponseSetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<VacationResponseSetRequest> jsResult = VacationSerializer$.MODULE$.deserializeVacationResponseSetRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            VacationResponseSetRequest vacationResponseSetRequest = (VacationResponseSetRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)vacationResponseSetRequest);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    private SMono<VacationResponseUpdateResults> update(MailboxSession mailboxSession, VacationResponseSetRequest vacationResponseSetRequest) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)vacationResponseSetRequest.parsePatch().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String id = (String)tuple2._1();
                Either either = (Either)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    VacationResponsePatchObject patch = (VacationResponsePatchObject)right.value();
                    return (SMono)patch.asVacationPatch().fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new VacationResponseUpdateFailure(id, (Throwable)e)), (Function1 & Serializable)validatedPatch -> this.update((VacationPatch)validatedPatch, mailboxSession));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String id = (String)tuple2._1();
            Either either = (Either)tuple2._2();
            if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)either;
            IllegalArgumentException e2 = (IllegalArgumentException)left.value();
            return SMono$.MODULE$.just((Object)new VacationResponseUpdateFailure(id, e2));
        }));
        Function1 & Serializable x$1 = (Function1 & Serializable)updateResultMono -> updateResultMono;
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)updateResult -> updateResult.asVacationResponseUpdateResults()).reduceWith((Function0 & Serializable)() -> VacationResponseUpdateResults$.MODULE$.empty(), (Function2 & Serializable)(a, b) -> VacationResponseUpdateResults$.MODULE$.merge((VacationResponseUpdateResults)a, (VacationResponseUpdateResults)b));
    }

    private SMono<VacationResponseUpdateResult> update(VacationPatch validatedPatch, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.vacationService.modifyVacation(this.toVacationAccountId(mailboxSession), validatedPatch)).then(SMono$.MODULE$.just((Object)VacationResponseUpdateSuccess$.MODULE$));
    }

    private org.apache.james.vacation.api.AccountId toVacationAccountId(MailboxSession mailboxSession) {
        return org.apache.james.vacation.api.AccountId.fromUsername((Username)mailboxSession.getUser());
    }

    private Invocation createResponse(Invocation invocation, VacationResponseSetRequest vacationResponseSetRequest, VacationResponseUpdateResults updateResult) {
        VacationResponseSetResponse response = new VacationResponseSetResponse(vacationResponseSetRequest.accountId(), UuidState$.MODULE$.INSTANCE(), (Option<Map<String, VacationResponseUpdateResponse>>)new Some(updateResult.updateSuccess()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty())), (Option<Map<String, VacationResponseSetError>>)new Some(updateResult.updateFailures()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())), this.validateNoCreate(vacationResponseSetRequest), this.validateNoDestroy(vacationResponseSetRequest));
        return new Invocation(this.methodName(), (JsObject)VacationSerializer$.MODULE$.serialize(response).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.methodCallId());
    }

    private Option<Map<String, VacationResponseSetError>> validateNoCreate(VacationResponseSetRequest vacationResponseSetRequest) {
        return vacationResponseSetRequest.create().map((Function1 & Serializable)aMap -> aMap.view().mapValues((Function1 & Serializable)x$4 -> VacationResponseSetError$.MODULE$.invalidArgument((Option<SetError.SetErrorDescription>)new Some((Object)new SetError.SetErrorDescription("'create' is not supported on singleton objects")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Option<Map<String, VacationResponseSetError>> validateNoDestroy(VacationResponseSetRequest vacationResponseSetRequest) {
        return vacationResponseSetRequest.destroy().map((Function1 & Serializable)aSet -> ((IterableOnceOps)aSet.map((Function1 & Serializable)id -> new Tuple2(id, (Object)VacationResponseSetError$.MODULE$.invalidArgument((Option<SetError.SetErrorDescription>)new Some((Object)new SetError.SetErrorDescription("'destroy' is not supported on singleton objects")))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Inject
    public VacationResponseSetMethod(@Named(value="JMAP") EventBus eventBus, VacationService vacationService, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.eventBus = eventBus;
        this.vacationService = vacationService;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"VacationResponse/set")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_VACATION_RESPONSE())}));
        Statics.releaseFence();
    }
}

