/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.jmap.routes.DownloadRoutes$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.compat.java8.FunctionConverters.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t\u001du!B\u0012%\u0011\u0003yc!B\u0019%\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u0007\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0011\u000b!\u0019!C\u0001\u000b\"1\u0011*\u0001Q\u0001\n\u00193A!\r\u0013\u0001\u0015\"Aqk\u0002BC\u0002\u0013\u0005\u0001\f\u0003\u0005`\u000f\t\u0005\t\u0015!\u0003Z\u0011!\u0001wA!b\u0001\n\u0003\t\u0007\u0002C3\b\u0005\u0003\u0005\u000b\u0011\u00022\t\u000be:A\u0011\u00014\t\u000fi<!\u0019!C\u0005w\"9\u0011qB\u0004!\u0002\u0013a\b\u0002CA\t\u000f\t\u0007I\u0011B>\t\u000f\u0005Mq\u0001)A\u0005y\"A\u0011QC\u0004C\u0002\u0013%1\u0010C\u0004\u0002\u0018\u001d\u0001\u000b\u0011\u0002?\t\u0011\u0005eqA1A\u0005\nmDq!a\u0007\bA\u0003%A\u0010\u0003\u0005\u0002\u001e\u001d\u0011\r\u0011\"\u0003|\u0011\u001d\tyb\u0002Q\u0001\nqDa!J\u0004\u0005B\u0005\u0005\u0002bBA\u001d\u000f\u0011%\u00111\b\u0005\b\u0003s9A\u0011BA<\u0011\u001d\tyj\u0002C\u0005\u0003CCq!!+\b\t\u0013\tY\u000bC\u0004\u0002T\u001e!I!!6\t\u000f\u0005}w\u0001\"\u0003\u0002b\"9!QD\u0004\u0005\n\t}\u0001b\u0002B\u0015\u000f\u0011%!1\u0006\u0005\b\u0005S9A\u0011\u0002B\u001b\u0011\u001d\u0011id\u0002C\u0005\u0005\u007fA\u0011Ba\u001c\b#\u0003%IA!\u001d\u0002\u001d\u0011{wO\u001c7pC\u0012\u0014v.\u001e;fg*\u0011QEJ\u0001\u0007e>,H/Z:\u000b\u0005\u001dB\u0013\u0001\u00026nCBT!!\u000b\u0016\u0002\u000b)\fW.Z:\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001!\t\u0001\u0014!D\u0001%\u00059!un\u001e8m_\u0006$'k\\;uKN\u001c\"!A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq&\u0001\u0004M\u001f\u001e;UIU\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tL\u0001\u0006g24GG[\u0005\u0003\u0005~\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\u0001\f\u0005V3e)\u0012*`'&SV)F\u0001G!\t!t)\u0003\u0002Ik\t\u0019\u0011J\u001c;\u0002\u0019\t+fIR#S?NK%,\u0012\u0011\u0014\u0007\u001dY5\u000b\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006!A.\u00198h\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\r=\u0013'.Z2u!\t!V+D\u0001'\u0013\t1fE\u0001\u0006K\u001b\u0006\u0003&k\\;uKN\fQ\"Y;uQ\u0016tG/[2bi>\u0014X#A-\u0011\u0005ikV\"A.\u000b\u0005q3\u0013\u0001\u00025uiBL!AX.\u0003\u001b\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u00039\tW\u000f\u001e5f]RL7-\u0019;pe\u0002\nQB\u00197pEJ+7o\u001c7wKJ\u001cX#\u00012\u0011\u0005A\u001a\u0017B\u00013%\u00055\u0011En\u001c2SKN|GN^3sg\u0006q!\r\\8c%\u0016\u001cx\u000e\u001c<feN\u0004CcA4ikB\u0011\u0001g\u0002\u0005\u0006/2\u0001\r!\u0017\u0015\u0005Q*\u00148\u000f\u0005\u0002la6\tAN\u0003\u0002n]\u00061\u0011N\u001c6fGRT\u0011a\\\u0001\u0006U\u00064\u0018\r_\u0005\u0003c2\u0014QAT1nK\u0012\fQA^1mk\u0016\f\u0013\u0001^\u0001\t%\u001a\u001bU\u0006\u000f\u001c3c!)\u0001\r\u0004a\u0001E\"\u0012Ab\u001e\t\u0003WbL!!\u001f7\u0003\r%s'.Z2u\u00039\t7mY8v]RLE\rU1sC6,\u0012\u0001 \t\u0004{\u0006%ab\u0001@\u0002\u0006A\u0011q0N\u0007\u0003\u0003\u0003Q1!a\u0001/\u0003\u0019a$o\\8u}%\u0019\u0011qA\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9!N\u0001\u0010C\u000e\u001cw.\u001e8u\u0013\u0012\u0004\u0016M]1nA\u0005Y!\r\\8c\u0013\u0012\u0004\u0016M]1n\u00031\u0011Gn\u001c2JIB\u000b'/Y7!\u0003%q\u0017-\\3QCJ\fW.\u0001\u0006oC6,\u0007+\u0019:b[\u0002\n\u0001cY8oi\u0016tG\u000fV=qKB\u000b'/Y7\u0002#\r|g\u000e^3oiRK\b/\u001a)be\u0006l\u0007%A\u0006e_^tGn\\1e+JL\u0017\u0001\u00043po:dw.\u00193Ve&\u0004CCAA\u0012!\u0019\t)#a\f\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0003[y\u0015\u0001B;uS2LA!!\r\u0002(\t11\u000b\u001e:fC6\u00042\u0001VA\u001b\u0013\r\t9D\n\u0002\n\u00156\u000b\u0005KU8vi\u0016\f1aZ3u)\u0019\ti$a\u0016\u0002nA1\u0011qHA'\u0003#j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\naV\u0014G.[:iKJTA!a\u0012\u0002J\u0005!1m\u001c:f\u0015\t\tY%A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005=\u0013\u0011\t\u0002\u0005\u001b>tw\u000eE\u0002M\u0003'J1!!\u0016N\u0005\u00111v.\u001b3\t\u000f\u0005e\u0003\u00041\u0001\u0002\\\u00059!/Z9vKN$\b\u0003BA/\u0003Sj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0007q\u000b)G\u0003\u0003\u0002h\u0005%\u0013!\u00028fiRL\u0018\u0002BA6\u0003?\u0012\u0011\u0003\u0013;uaN+'O^3s%\u0016\fX/Z:u\u0011\u001d\ty\u0007\u0007a\u0001\u0003c\n\u0001B]3ta>t7/\u001a\t\u0005\u0003;\n\u0019(\u0003\u0003\u0002v\u0005}#A\u0005%uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016$\u0002\"!\u001f\u0002\f\u00065\u0015q\u0012\t\u0007\u0003w\n\t)!\"\u000e\u0005\u0005u$\u0002BA\"\u0003\u007fR1ANA#\u0013\u0011\t\u0019)! \u0003\u000bMkuN\\8\u0011\u0007Q\n9)C\u0002\u0002\nV\u0012A!\u00168ji\"9\u0011\u0011L\rA\u0002\u0005m\u0003bBA83\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003#K\u0002\u0019AAJ\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033C\u0013aB7bS2\u0014w\u000e_\u0005\u0005\u0003;\u000b9J\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0002\u0015\u001d,G/\u00134Po:,'\u000f\u0006\u0005\u0002z\u0005\r\u0016QUAT\u0011\u001d\tIF\u0007a\u0001\u00037Bq!a\u001c\u001b\u0001\u0004\t\t\bC\u0004\u0002\u0012j\u0001\r!a%\u0002\u0019\u0011|wO\u001c7pC\u0012\u0014En\u001c2\u0015\u0015\u0005e\u0014QVA\\\u0003s\u000bI\rC\u0004\u00020n\u0001\r!!-\u0002\u0019=\u0004H/[8oC2t\u0015-\\3\u0011\tQ\n\u0019\f`\u0005\u0004\u0003k+$AB(qi&|g\u000eC\u0004\u0002pm\u0001\r!!\u001d\t\u000f\u0005m6\u00041\u0001\u0002>\u0006y!\r\\8c\u0007>tG/\u001a8u)f\u0004X\r\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\u0011\t\u0019-a&\u0002\u000b5|G-\u001a7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\f\u0007>tG/\u001a8u)f\u0004X\rC\u0004\u0002Ln\u0001\r!!4\u0002\t\tdwN\u0019\t\u0004a\u0005=\u0017bAAiI\t!!\t\\8c\u0003m\tG\rZ\"p]R,g\u000e\u001e#jgB|7/\u001b;j_:DU-\u00193feR!\u0011q[Ao!\u001d!\u0014\u0011\\A9\u0003cJ1!a76\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u00020r\u0001\r!!-\u0002-\u0005$GmQ8oi\u0016tG\u000fT3oORD\u0007*Z1eKJ$B!a6\u0002d\"9\u0011Q]\u000fA\u0002\u0005\u001d\u0018aB:ju\u0016$&/\u001f\t\u0007\u0003S\fi/!=\u000e\u0005\u0005-(bAA\u0017k%!\u0011q^Av\u0005\r!&/\u001f\t\u0005\u0003g\u00149B\u0004\u0003\u0002v\nEa\u0002BA|\u0005\u001bqA!!?\u0003\n9!\u00111 B\u0004\u001d\u0011\tiP!\u0002\u000f\t\u0005}(1\u0001\b\u0004\u007f\n\u0005\u0011\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&C\u0002\u0003\f\u0019\n1!\u00199j\u0013\u0011\t\u0019Ma\u0004\u000b\u0007\t-a%\u0003\u0003\u0003\u0014\tU\u0011\u0001B*ju\u0016TA!a1\u0003\u0010%!!\u0011\u0004B\u000e\u0005\u0011\u0019\u0016N_3\u000b\t\tM!QC\u0001-C\u0012$7i\u001c8uK:$H)[:q_NLG/[8o\u0011\u0016\fG-\u001a:SK\u001e\f'\u000fZ5oO\u0016s7m\u001c3j]\u001e$b!!\u001d\u0003\"\t\u0015\u0002B\u0002B\u0012=\u0001\u0007A0\u0001\u0003oC6,\u0007b\u0002B\u0014=\u0001\u0007\u0011\u0011O\u0001\u0005e\u0016\u001c\b/\u0001\u0006rk\u0016\u0014\u0018\u0010U1sC6$b!!-\u0003.\tE\u0002b\u0002B\u0018?\u0001\u0007\u00111L\u0001\fQR$\bOU3rk\u0016\u001cH\u000f\u0003\u0004\u00034}\u0001\r\u0001`\u0001\u000ea\u0006\u0014\u0018-\\3uKJt\u0015-\\3\u0015\r\u0005E&q\u0007B\u001d\u0011\u0019\u0011\u0019\u0004\ta\u0001y\"1!1\b\u0011A\u0002q\f1!\u001e:j\u00039\u0011Xm\u001d9p]\u0012$U\r^1jYN$\u0002\"!\u001f\u0003B\t\u0015#1\u000b\u0005\b\u0005\u0007\n\u0003\u0019AA9\u0003IAG\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\t\u000f\t\u001d\u0013\u00051\u0001\u0003J\u00059A-\u001a;bS2\u001c\b\u0003\u0002B&\u0005\u001fj!A!\u0014\u000b\u0007\u0005\u001dc%\u0003\u0003\u0003R\t5#A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d\u0005\n\u0005+\n\u0003\u0013!a\u0001\u0005/\n!b\u001d;biV\u001c8i\u001c3f!\u0011\u0011IFa\u001b\u000e\u0005\tm#b\u0001/\u0003^)!!q\fB1\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011\u0019G!\u001a\u0002\u000f!\fg\u000e\u001a7fe*!\u0011q\rB4\u0015\t\u0011I'\u0001\u0002j_&!!Q\u000eB.\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u00021I,7\u000f]8oI\u0012+G/Y5mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003t)\"!q\u000bB;W\t\u00119\b\u0005\u0003\u0003z\t\rUB\u0001B>\u0015\u0011\u0011iHa \u0002\u0013Ut7\r[3dW\u0016$'b\u0001BAk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015%1\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DownloadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final BlobResolvers blobResolvers;
    private final String accountIdParam;
    private final String blobIdParam;
    private final String nameParam;
    private final String contentTypeParam;
    private final String downloadUri;

    public static int BUFFER_SIZE() {
        return DownloadRoutes$.MODULE$.BUFFER_SIZE();
    }

    public static Logger LOGGER() {
        return DownloadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public BlobResolvers blobResolvers() {
        return this.blobResolvers;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String blobIdParam() {
        return this.blobIdParam;
    }

    private String nameParam() {
        return this.nameParam;
    }

    private String contentTypeParam() {
        return this.contentTypeParam;
    }

    private String downloadUri() {
        return this.downloadUri;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, this.downloadUri())).action((request, response) -> this.get(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.downloadUri())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private Mono<Void> get(HttpServerRequest request, HttpServerResponse response) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getIfOwner(request, response, (MailboxSession)mailboxSession)).onErrorResume((Function1 & Serializable)x0$1 -> {
            SMono<BoxedUnit> sMono;
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenException) {
                HttpResponseStatus x$1 = HttpResponseStatus.FORBIDDEN;
                String x$2 = "You cannot download in others accounts";
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, "You cannot download in others accounts"), HttpResponseStatus.FORBIDDEN);
            } else if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                DownloadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
                String x$6 = unauthorizedException.getMessage();
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.UNAUTHORIZED);
            } else if (throwable instanceof BlobNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.NOT_FOUND;
                String x$10 = "The resource could not be found";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "The resource could not be found"), HttpResponseStatus.NOT_FOUND);
            } else {
                DownloadRoutes$.MODULE$.LOGGER().error("Unexpected error upon downloads", throwable);
                HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                String x$14 = throwable.getMessage();
                String x$15 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return sMono;
        }).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private SMono<BoxedUnit> get(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        return ((SMono)BlobId$.MODULE$.of(request.param((CharSequence)this.blobIdParam())).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)x$4 -> this.blobResolvers().resolve((BlobId)x$4, mailboxSession))).flatMap((Function1 & Serializable)blob -> this.downloadBlob(this.queryParam(request, this.nameParam()), response, (ContentType)this.queryParam(request, this.contentTypeParam()).map((Function1 & Serializable)x$1 -> ContentType.of((String)x$1)).getOrElse((Function0 & Serializable)() -> blob.contentType()), (Blob)blob).then());
    }

    private SMono<BoxedUnit> getIfOwner(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        SMono sMono;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            sMono = (SMono)AccountId$.MODULE$.from(mailboxSession.getUser()).map((Function1 & Serializable)accountId -> BoxesRunTime.boxToBoolean((boolean)accountId.equals(targetAccountId))).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)value -> DownloadRoutes.$anonfun$getIfOwner$3(this, request, response, mailboxSession, BoxesRunTime.unboxToBoolean((Object)value)));
        } else if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            sMono = SMono$.MODULE$.error((Throwable)illegalArgumentException);
        } else {
            throw new MatchError(either);
        }
        return sMono;
    }

    private SMono<BoxedUnit> downloadBlob(Option<String> optionalName, HttpServerResponse response, ContentType blobContentType, Blob blob) {
        return SMono$.MODULE$.fromPublisher((Publisher)Mono.using(() -> blob.content(), stream -> ((HttpServerResponse)this.addContentDispositionHeader(optionalName).compose(this.addContentLengthHeader(blob.size())).apply((Object)response)).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)blobContentType.asString()).status(HttpResponseStatus.OK).send((Publisher)ReactorUtils.toChunks((InputStream)stream, (int)DownloadRoutes$.MODULE$.BUFFER_SIZE()).map(x$5 -> Unpooled.wrappedBuffer((ByteBuffer)x$5)).subscribeOn(Schedulers.elastic())).then(), (Consumer)package$.MODULE$.asJavaConsumer((Function1 & Serializable)stream -> {
            stream.close();
            return BoxedUnit.UNIT;
        }))).then();
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentDispositionHeader(Option<String> optionalName) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)optionalName.map((Function1 & Serializable)x$6 -> this.addContentDispositionHeaderRegardingEncoding((String)x$6, (HttpServerResponse)resp)).getOrElse((Function0 & Serializable)() -> resp);
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentLengthHeader(Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> sizeTry) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)sizeTry.map((Function1 & Serializable)size -> resp.header((CharSequence)"Content-Length", (CharSequence)((Long)((Refined)size).value()).toString())).getOrElse((Function0 & Serializable)() -> resp);
    }

    private HttpServerResponse addContentDispositionHeaderRegardingEncoding(String name, HttpServerResponse resp) {
        return CharMatcher.ascii().matchesAllOf((CharSequence)name) ? resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(23).append("attachment; filename=\"").append(name).append("\"").toString()) : resp.header((CharSequence)"Content-Disposition", (CharSequence)new StringBuilder(24).append("attachment; filename*=\"").append(EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN)).append("\"").toString());
    }

    private Option<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Option<String> queryParam(String parameterName, String uri) {
        return Option$.MODULE$.apply(new QueryStringDecoder(uri).parameters().get(parameterName)).toList().flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7).asScala()).headOption();
    }

    private SMono<BoxedUnit> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(statusCode).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()).then());
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ SMono $anonfun$getIfOwner$3(DownloadRoutes $this, HttpServerRequest request$3, HttpServerResponse response$3, MailboxSession mailboxSession$4, boolean value) {
        return value ? $this.get(request$3, response$3, mailboxSession$4) : SMono$.MODULE$.error((Throwable)new ForbiddenException());
    }

    @Inject
    public DownloadRoutes(@Named(value="RFC-8621") Authenticator authenticator, BlobResolvers blobResolvers) {
        this.authenticator = authenticator;
        this.blobResolvers = blobResolvers;
        this.accountIdParam = "accountId";
        this.blobIdParam = "blobId";
        this.nameParam = "name";
        this.contentTypeParam = "type";
        this.downloadUri = new StringBuilder(15).append("/download/{").append(this.accountIdParam()).append("}/{").append(this.blobIdParam()).append("}").toString();
    }
}

