/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;

public class PgpDecryptionKeyStoreLoader
extends AKeyLoader<PgpDecryptionKey, Long> {
    private final PGPSecretKeyRingCollection keyRings;
    private final char[] password;

    public PgpDecryptionKeyStoreLoader(PGPSecretKeyRingCollection keyRings, char[] password) {
        this.keyRings = keyRings;
        this.password = password;
        if (keyRings == null) {
            throw new IllegalArgumentException("Key Ring Collection must not be null.");
        }
    }

    @Override
    protected PgpDecryptionKey loadInternalKey(Long forId) throws Exception {
        PGPSecretKeyRing secretKeyRing = this.keyRings.getSecretKeyRing(forId.longValue());
        if (secretKeyRing == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        PGPSecretKey secretKey = secretKeyRing.getSecretKey(forId.longValue());
        PgpDecryptionKey key = new PgpDecryptionKey(PgpUtil.extractPrivateKey(secretKey, this.password), secretKeyRing.getPublicKey());
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpDecryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpDecryptionKey(validity, this.getKeySource());
    }

    public PGPSecretKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String toString() {
        return "PgpDecryptionKeyStoreLoader [keyRings=" + this.keyRings + ", password=*****]";
    }
}

