/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;

public class PgpPublicKeyStoreLoader
extends AKeyLoader<PgpEncryptionKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final PGPPublicKeyRingCollection keyRings;

    public PgpPublicKeyStoreLoader(PGPPublicKeyRingCollection keyRings) {
        this.keyRings = keyRings;
    }

    @Override
    protected PgpEncryptionKey loadInternalKey(String email) throws Exception {
        if (this.getKeyRings() == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Logger log = this.getLog();
        log.info("Looking up PGP public key for email <{}> in key rings.", (Object)email);
        PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(this.getKeyRings(), email);
        if (keyRing != null) {
            log.info("Found valid PGP public key ring for email <{}> in key store.", (Object)email);
            log.trace("Found PGP public key ring: {}", (Object)keyRing);
            this.getInfoDataManager().send(new InfoData(202, email));
            PgpEncryptionKey key = new PgpEncryptionKey(keyRing, email);
            key.setKeySource(this.getKeySource());
            return key;
        }
        log.info("Found no PGP public key for email {} in key store.", (Object)email);
        this.getInfoDataManager().send(new InfoData(203, email));
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, this.getKeySource());
    }

    public PGPPublicKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String toString() {
        return "PgpPublicKeyStoreLoader [keyRings=" + this.keyRings + "]";
    }
}

