/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyBoxLoader;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;

public class PgpValidationKeyBoxLoader
extends AKeyBoxLoader<PgpValidationKey, Long, PublicKeyRingBlob> {
    public PgpValidationKeyBoxLoader(KeyBox keyBox) {
        super(keyBox, BlobType.OPEN_PGP_BLOB);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpValidationKey loadKeyFromBlob(PublicKeyRingBlob blob, Long id) throws Exception {
        PGPPublicKeyRing ring = blob.getPGPPublicKeyRing();
        PGPPublicKey pgpKey = ring.getPublicKey(id.longValue());
        if (pgpKey == null) {
            return null;
        }
        PgpValidationKey key = new PgpValidationKey(pgpKey);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    protected PgpValidationKey getValidityKey(EKeyValidity validity) {
        return new PgpValidationKey(validity, this.getKeySource());
    }
}

