/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.expose;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.mail.expose.IMailHeaderExposer;
import net.savignano.cryptography.mail.protect.ProtectedHeadersMailHeaderProtector;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.util.MessageUtil;

public abstract class AMailHeaderExposer
extends ManipulateMessageVisitor
implements IMailHeaderExposer {
    private MimeMessage msg;

    @Override
    public void exposeHeaders(MimeMessage msg) throws MessagingException {
        this.msg = msg;
        try {
            this.visit(msg);
            if (this.isChanged()) {
                this.getLog().info("Exposed protected headers for message with ID: {}", (Object)MessageUtil.getMessageId((Message)msg));
            }
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    @Override
    public void visit(MimeMessage msg) throws Exception {
        if (msg.isMimeType("message/rfc822")) {
            this.reset();
            this.unwrapHeaders(msg);
            this.setChanged(true);
        } else {
            super.visit(msg);
        }
    }

    private void unwrapHeaders(MimeMessage msg) throws IOException, MessagingException {
        this.getLog().debug("Found RFC822 protected headers.");
        MimePart part = (MimePart)msg.getContent();
        msg.setDataHandler(part.getDataHandler());
        MessageUtil.copyAllHeaders((Part)part, (Part)msg);
        msg.saveChanges();
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        if (part != this.getMessage() && ProtectedHeadersMailHeaderProtector.isProtectedHeaders((Part)part)) {
            this.getLog().debug("Found protected headers.");
            MessageUtil.copyNonMatchingHeaders((Part)part, (Part)this.getMessage(), Constants.STRUCTURAL_MIME_HEADERS);
            this.setChanged(true);
        }
        if (part.isMimeType("multipart/mixed") && this.isLegacy((MimeMultipart)part.getContent())) {
            this.getLog().debug("Found legacy part.");
            BodyPart contentPart = ((MimeMultipart)part.getContent()).getBodyPart(1);
            MessageUtil.movePart((Part)contentPart, (Part)part);
            this.setChanged(true);
        }
    }

    private boolean isLegacy(MimeMultipart multi) throws MessagingException {
        BodyPart part0;
        ContentType type;
        if (multi.getCount() == 2 && ((type = new ContentType((part0 = multi.getBodyPart(0)).getContentType())).match("text/plain") || type.match("text/rfc822-headers"))) {
            return ProtectedHeadersMailHeaderProtector.isProtectedHeaders(type);
        }
        return false;
    }

    protected MimeMessage getMessage() {
        return this.msg;
    }
}

