/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.protect;

import java.io.IOException;
import java.util.Objects;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import net.savignano.cryptography.mail.protect.IMailHeaderProtector;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedHeadersMailHeaderProtector
implements IMailHeaderProtector {
    private static final Logger log = LoggerFactory.getLogger(ProtectedHeadersMailHeaderProtector.class);

    public static final boolean isProtectedHeaders(Part part) throws MessagingException {
        return ProtectedHeadersMailHeaderProtector.isProtectedHeaders(part.getContentType());
    }

    public static final boolean isProtectedHeaders(String type) throws ParseException {
        return ProtectedHeadersMailHeaderProtector.isProtectedHeaders(new ContentType(type));
    }

    public static final boolean isProtectedHeaders(ContentType type) {
        String parameter = type.getParameter("protected-headers");
        return Objects.equals(parameter, "v1");
    }

    @Override
    public void protectHeaders(MimeMessage msg) throws IOException, MessagingException {
        log.info("Protecting headers of message with ID {} with protected-headers method.", (Object)MessageUtil.getMessageId((Message)msg));
        ContentType type = new ContentType(msg.getContentType());
        log.trace("Content type: {}", (Object)type);
        String parameter = type.getParameter("protected-headers");
        if (parameter == null) {
            type.setParameter("protected-headers", "v1");
            msg.setHeader("Content-Type", type.toString());
            msg.saveChanges();
        } else if (parameter.equalsIgnoreCase("v1")) {
            log.debug("Protected headers parameter already present.");
        } else {
            throw new MessagingException("protected-headers parameter already present in content type with an unknown value. Cannot protect headers. Value: " + parameter);
        }
    }
}

