/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.sign;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.mail.sign.AMailSigner;
import net.savignano.cryptography.mail.sign.SmimeSigningResult;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSet;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.Attribute;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaCertStore;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAttributeTableGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESignedGenerator;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

public class SmimeMailSigner
extends AMailSigner<SmimeSignKey, SmimeSigningResult> {
    private boolean opaque;

    public SmimeMailSigner(Session session) {
        super(session, ECryptographyType.SMIME);
    }

    @Override
    protected SmimeSigningResult createResult(MimeMessage msg) {
        return new SmimeSigningResult(msg);
    }

    @Override
    protected void sign(SmimeSignKey key, SmimeSigningResult result) throws Exception {
        String algorithm = "SHA256withRSA";
        SMIMESignedGenerator gen = this.prepareGenerator(key, "SHA256withRSA");
        MimeMessage msg = result.getMessage();
        if (this.isOpaque()) {
            this.signOpaque(msg, gen);
        } else {
            this.signTransparent(msg, gen);
        }
        this.includeSignatureHeader(msg, "SHA256withRSA");
        msg.saveChanges();
    }

    private SMIMESignedGenerator prepareGenerator(SmimeSignKey key, String algorithm) throws CertificateEncodingException, OperatorCreationException {
        this.getLog().debug("Preparing S/MIME Signed generator.");
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        SignerInfoGenerator build = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(SecurityUtil.getProvider()).setSignedAttributeGenerator(this.createSignedAttrGenerator()).build(algorithm, key.getKey(), key.getPublicCert());
        gen.addSignerInfoGenerator(build);
        JcaCertStore certStore = new JcaCertStore(key.getAttachedCerts());
        gen.addCertificates((Store)certStore);
        return gen;
    }

    private CMSAttributeTableGenerator createSignedAttrGenerator() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.createSmimeCapabilities());
        AttributeTable table = new AttributeTable(vector);
        DefaultSignedAttributeTableGenerator generator = new DefaultSignedAttributeTableGenerator(table);
        return generator;
    }

    private Attribute createSmimeCapabilities() {
        ArrayList<DLSequence> smimeCapas = new ArrayList<DLSequence>();
        smimeCapas.add(new DLSequence((ASN1Encodable)NISTObjectIdentifiers.id_aes256_GCM));
        smimeCapas.add(new DLSequence((ASN1Encodable)NISTObjectIdentifiers.id_aes256_CBC));
        smimeCapas.add(new DLSequence((ASN1Encodable)PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305));
        smimeCapas.add(new DLSequence((ASN1Encodable)NISTObjectIdentifiers.id_aes128_GCM));
        smimeCapas.add(new DLSequence((ASN1Encodable)NISTObjectIdentifiers.id_aes128_CBC));
        DLSet set = new DLSet((ASN1Encodable)new DLSequence(smimeCapas.toArray(new ASN1Encodable[smimeCapas.size()])));
        return new Attribute(PKCSObjectIdentifiers.pkcs_9_at_smimeCapabilities, (ASN1Set)set);
    }

    private void signTransparent(MimeMessage msg, SMIMESignedGenerator gen) throws IOException, MessagingException, SMIMEException {
        this.getLog().debug("Signing message in a transparent way.");
        MimeBodyPart toSign = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)toSign);
        MimeMultipart mm = gen.generate(toSign);
        MessageUtil.removeMatchingHeaders((Part)msg, Constants.STRUCTURAL_MIME_HEADERS);
        msg.setContent((Multipart)mm);
    }

    private void signOpaque(MimeMessage msg, SMIMESignedGenerator gen) throws IOException, MessagingException, SMIMEException {
        this.getLog().debug("Signing message in an opaque way.");
        MimeBodyPart toSign = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)toSign);
        MimeBodyPart signedPart = gen.generateEncapsulated(toSign);
        MessageUtil.movePart((Part)signedPart, (Part)msg);
        MessageUtil.copyAllHeaders((Part)signedPart, (Part)msg);
        msg.saveChanges();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }
}

