/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailValidator<T extends IPublicCryptographyKey<?>>
extends BaseMailCryptography
implements IMailValidator<T> {
    protected AMailValidator(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    protected abstract T getValidityKey(EKeyValidity var1);

    @Override
    public Set<EValidationType> validate(MimeMessage msg) throws IOException, MessagingException {
        EnumSet<EValidationType> validated = EnumSet.noneOf(EValidationType.class);
        if (msg == null) {
            return validated;
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            if (!this.isSigned(msg)) {
                log.info("Message with msg ID \"{}\" is not signed.", (Object)msgId);
                return validated;
            }
        }
        catch (Exception e) {
            String errMsg = "Could not check if message with msg ID " + msgId + " is signed. Error message: " + e.getMessage();
            throw new MessagingException(errMsg, e);
        }
        log.info("Validating {} message with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Email:\n{}");
        try {
            validated.addAll(this.doValidate(msg));
        }
        catch (Exception e) {
            String errMsg = "Could not validate message with msg ID " + msgId + ". Error message: " + e.getMessage();
            throw new MessagingException(errMsg, e);
        }
        log.info("Finished validating {} message with msg ID {}. Result: {}", new Object[]{this.getCryptography(), msgId, validated});
        return validated;
    }

    protected abstract Set<EValidationType> doValidate(MimeMessage var1) throws Exception;
}

