/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.ValidityKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.mail.validate.AMailValidator;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.mail.visitor.extract.PgpMailExtractor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.LoggerFactory;

public class PgpMailValidator
extends AMailValidator<PgpEncryptionKey> {
    private Function<Long, ? extends IPublicCryptographyKey<PGPPublicKey>> publicKeyRetriever = id -> ValidityKey.notFoundPgpKey();
    private boolean checkInline;

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        return PgpMailValidator.isSigned((MimePart)message);
    }

    private static final boolean isSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && protocol.equalsIgnoreCase("application/pgp-signature");
            }
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(PgpMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final boolean isMessageSignedInline(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        ResultMessageVisitor<Boolean> visitor = new ResultMessageVisitor<Boolean>(Boolean.valueOf(false)){
            {
                this.setContentType("text/plain");
            }

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (((Boolean)this.getResult()).booleanValue()) {
                    return;
                }
                Object content = part.getContent();
                this.setResult(content instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----"));
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PgpMailValidator.class).error(e.getMessage(), (Throwable)e);
        }
        return (Boolean)visitor.getResult();
    }

    public PgpMailValidator(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.CAN_VALIDATE, EValidationType.EMAIL_ADDRESS, EValidationType.SIGNATURE);
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, EKeySource.EMAIL);
    }

    @Override
    public boolean isSigned(MimeMessage msg) throws IOException, MessagingException {
        return PgpMailValidator.isMessageSigned((Message)msg) || this.isCheckInline() && PgpMailValidator.isMessageSignedInline((Message)msg);
    }

    @Override
    protected Set<EValidationType> doValidate(MimeMessage msg) throws Exception {
        ValidateVisitor visitor = new ValidateVisitor(this.getValidationKeyRetriever(), this.getSession(), this.isCheckInline());
        visitor.visit(msg);
        return (Set)visitor.getResult();
    }

    public Function<Long, ? extends IPublicCryptographyKey<PGPPublicKey>> getValidationKeyRetriever() {
        return this.publicKeyRetriever;
    }

    public void setValidationKeyRetriever(Function<Long, ? extends IPublicCryptographyKey<PGPPublicKey>> publicKeyRetriever) {
        this.publicKeyRetriever = publicKeyRetriever;
        if (publicKeyRetriever == null) {
            throw new IllegalArgumentException("Function must not be null.");
        }
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }

    protected static final class ValidateVisitor
    extends ResultMessageVisitor<Set<EValidationType>> {
        private final PgpUtil.GetKeyFunction<PGPPublicKey> keyRetriever;
        private final Session session;
        private final boolean checkInline;
        private Function<Long, PGPPublicKey> messageKeyRetriever;
        private PGPPublicKey usedKey;
        private boolean invalidSignature;

        public ValidateVisitor(Function<Long, ? extends ICryptographyKey<PGPPublicKey>> externalKeyRetriever, Session session, boolean checkInline) {
            super(EnumSet.noneOf(EValidationType.class));
            this.session = session;
            this.checkInline = checkInline;
            this.keyRetriever = id -> {
                PGPPublicKey key = this.messageKeyRetriever.apply(id);
                if (key == null) {
                    key = (PGPPublicKey)((ICryptographyKey)externalKeyRetriever.apply(id)).getKey();
                }
                if (key != null) {
                    ((Set)this.getResult()).add(EValidationType.CAN_VALIDATE);
                }
                this.usedKey = key;
                return key;
            };
        }

        @Override
        protected void reset() {
            super.reset();
            this.invalidSignature = false;
            this.usedKey = null;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            Optional<String> from;
            this.getLog().debug("Validating message.");
            PgpMailExtractor extractor = new PgpMailExtractor(this.session);
            PgpEncryptionKey extractedKey = (PgpEncryptionKey)extractor.extractPublicKey(msg);
            this.messageKeyRetriever = extractedKey.isValid() ? id -> extractedKey.getKey((long)id) : id -> null;
            super.visit(msg);
            if (this.usedKey != null && (from = MessageUtil.getFromEmail(msg)).isPresent() && PgpUtil.isKeyForEmail(this.usedKey, from.get())) {
                ((Set)this.getResult()).add(EValidationType.EMAIL_ADDRESS);
            }
        }

        @Override
        protected boolean isRelevant(ContentType type) {
            if (type.match("multipart/signed") && "application/pgp-signature".equalsIgnoreCase(type.getParameter("protocol"))) {
                return true;
            }
            return this.checkInline && type.match("text/plain");
        }

        @Override
        protected void handleMultipart(MimeMultipart mp) throws Exception {
            if (this.sanityCheck(mp)) {
                this.validate(mp);
            }
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            Object content = part.getContent();
            if (content instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
                this.validate(part);
            }
        }

        private boolean sanityCheck(MimeMultipart mp) throws MessagingException {
            if (mp.getCount() != 2) {
                this.getLog().warn("PGP signature does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
                return false;
            }
            if (!mp.getBodyPart(1).isMimeType("application/pgp-signature")) {
                this.getLog().warn("PGP signature does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
                return false;
            }
            this.getLog().debug("Sanity check of PGP signature successful.");
            return true;
        }

        private void validate(MimeMultipart mp) throws Exception {
            if (this.alreadyInvalidSignature()) {
                return;
            }
            this.setResult(EnumSet.noneOf(EValidationType.class));
            this.getLog().debug("Validating message.");
            MimeBodyPart contentPart = (MimeBodyPart)mp.getBodyPart(0);
            MimeBodyPart sigPart = (MimeBodyPart)mp.getBodyPart(1);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            contentPart.writeTo((OutputStream)os);
            byte[] contentBytes = os.toByteArray();
            os.reset();
            sigPart.writeTo((OutputStream)os);
            byte[] sigBytes = os.toByteArray();
            if (PgpUtil.verify(contentBytes, sigBytes, this.keyRetriever)) {
                ((Set)this.getResult()).add(EValidationType.SIGNATURE);
            }
            this.invalidSignature = ((Set)this.getResult()).containsAll((Collection)this.getDefaultResult());
        }

        private void validate(MimePart part) throws Exception {
            if (this.alreadyInvalidSignature()) {
                return;
            }
            this.setResult(EnumSet.noneOf(EValidationType.class));
            this.getLog().debug("Validating inline message.");
            String fullContent = (String)part.getContent();
            String signature = this.getSignature(fullContent);
            String text = this.getTextRemoveHeaders(fullContent);
            if (PgpUtil.verify(text.getBytes(), signature.getBytes(), this.keyRetriever)) {
                ((Set)this.getResult()).add(EValidationType.SIGNATURE);
            } else {
                String plainText = this.getText(fullContent);
                if (PgpUtil.verify(plainText.getBytes(), signature.getBytes(), this.keyRetriever)) {
                    ((Set)this.getResult()).add(EValidationType.SIGNATURE);
                }
            }
            this.invalidSignature = ((Set)this.getResult()).containsAll((Collection)this.getDefaultResult());
        }

        private boolean alreadyInvalidSignature() {
            return this.invalidSignature;
        }

        private String getText(String fullContent) {
            int startIndex = "-----BEGIN PGP SIGNED MESSAGE-----".length();
            int endIndex = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            String cropped = fullContent.substring(startIndex, endIndex);
            return this.removeLinebreaks(cropped);
        }

        private String getTextRemoveHeaders(String fullContent) throws MessagingException, IOException {
            StringBuilder builder = new StringBuilder(fullContent.length());
            ContentType contentType = new ContentType("text/plain");
            contentType.setParameter("charset", "UTF-8");
            builder.append("Content-Type");
            builder.append(": ");
            builder.append(contentType.toString());
            builder.append("\r\n");
            builder.append(this.getText(fullContent));
            MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(builder.toString().getBytes(Constants.UTF8_CHARSET)));
            return (String)part.getContent();
        }

        private String getSignature(String fullContent) {
            int startSig = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            return fullContent.substring(startSig);
        }

        private String removeLinebreaks(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            int start = str.startsWith("\r\n") ? 2 : (str.charAt(0) == '\r' || str.charAt(0) == '\n' ? 1 : 0);
            int end = str.endsWith("\r\n") ? str.length() - 2 : (str.charAt(str.length() - 1) == '\r' || str.charAt(str.length() - 1) == '\n' ? str.length() - 1 : str.length());
            return str.substring(start, end);
        }
    }
}

