/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.security;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SavignanoJce
extends Provider {
    public static final String CODESIGNING_NAME = "O=Oracle Corporation,OU=Java Software Code Signing,CN=Savignano Software Solutions";
    private static final long serialVersionUID = 4997058943902217240L;
    private static final Logger log = LoggerFactory.getLogger(SavignanoJce.class);

    public static synchronized boolean selfIntegrityChecking() {
        log.debug("Starting 'Self Integrity Checking' of savignano jar-file.");
        URL providerUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                CodeSource cs = SavignanoJce.class.getProtectionDomain().getCodeSource();
                return cs.getLocation();
            }
        });
        log.debug("Provider URL for Jar: {}", (Object)providerUrl);
        return SavignanoJce.integrityChecking(providerUrl);
    }

    public static boolean integrityChecking(URL providerUrl) {
        log.debug("Provider URL to check: {}", (Object)providerUrl);
        if (providerUrl == null) {
            return false;
        }
        JarVerifier jv = new JarVerifier(providerUrl);
        try {
            X509Certificate providerCert = SavignanoJce.setupProviderCert();
            SavignanoJce.verifyCertificate(providerCert);
            jv.verify(providerCert);
        }
        catch (Exception e) {
            log.debug("Error during integrity checking. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        log.debug("Integrity checking successful.");
        return true;
    }

    private static X509Certificate setupProviderCert() throws IOException, CertificateException {
        try (InputStream in = SavignanoJce.class.getResourceAsStream("/jce-codesign-savignano-sw.cer");){
            X509Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(in);
            return x509Certificate;
        }
    }

    private static void verifyCertificate(X509Certificate cert) {
        log.debug("Checking if provider certificate has correct values.");
        X500Name subject = SmimeUtil.getSubject(cert);
        if (!new X500Name(CODESIGNING_NAME).equals((Object)subject)) {
            throw new SecurityException("Provider certificate is not from Savignano Software Solutions.");
        }
    }

    public SavignanoJce() {
        super("SavignanoJCE", 1.0, "Provider just to check integrity of savignano jars.");
    }

    private static class JarVerifier {
        private URL jarURL = null;
        private JarFile jarFile = null;

        JarVerifier(URL jarURL) {
            this.jarURL = jarURL;
        }

        private JarFile retrieveJarFileFromURL(URL url) throws PrivilegedActionException, MalformedURLException {
            log.debug("Retrieving JAR file from URL: {}", (Object)url);
            JarFile jf = null;
            this.jarURL = url.getProtocol().equalsIgnoreCase("jar") ? url : new URL("jar:" + url.toString() + "!/");
            jf = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
                    conn.setUseCaches(false);
                    return conn.getJarFile();
                }
            });
            return jf;
        }

        public void verify(X509Certificate targetCert) throws IOException {
            if (targetCert == null) {
                throw new SecurityException("Provider certificate is not present.");
            }
            try {
                if (this.jarFile == null) {
                    this.jarFile = this.retrieveJarFileFromURL(this.jarURL);
                }
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException();
                se.initCause(ex);
                throw se;
            }
            Manifest man = this.jarFile.getManifest();
            log.debug("Manifest file present: {}", (Object)(man != null ? 1 : 0));
            if (man == null) {
                throw new SecurityException("The provider is not signed. Manifest file not found.");
            }
            ArrayList<JarEntry> verifyEntries = new ArrayList<JarEntry>();
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                verifyEntries.add(je);
                log.trace("Reading jar entry: {}", (Object)je);
                InputStream is = this.jarFile.getInputStream(je);
                Throwable throwable = null;
                try {
                    while (is.read(buffer, 0, buffer.length) != -1) {
                    }
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            for (JarEntry je : verifyEntries) {
                X509Certificate[] certChain;
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    log.trace("No signature found for: {}", (Object)je);
                    if (je.getName().startsWith("META-INF")) continue;
                    log.error("Jar entry was not signed: {}", (Object)je);
                    throw new SecurityException("The provider has unsigned class files.");
                }
                log.trace("Signature found for: {}", (Object)je);
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(targetCert)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                log.error("Jar entry was not signed with the expected signer: {}", (Object)je);
                throw new SecurityException("The provider is not signed with the expected signer.");
            }
        }

        private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }

        protected void finalize() throws Throwable {
            this.jarFile.close();
        }
    }
}

