/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;

public enum CloudProvider {
    Azure{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/metadata/instance/compute/vmId?api-version=2021-02-01&format=text", "Metadata", "true");
        }
    }
    ,
    AWS{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/latest/meta-data/instance-id", "Metadata", "true");
        }
    }
    ,
    Google{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://metadata.google.internal/computeMetadata/v1/instance?alt=text", "Metadata-Flavor", "Google");
        }
    }
    ,
    Oracle{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/opc/v2/instance/id", "Authorization", "Bearer Oracle");
        }
    }
    ,
    DigitalOcean{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/metadata/v1/id", null);
        }
    }
    ,
    AliBaba{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://100.100.100.200/latest/meta-data/instance-id", null);
        }
    }
    ,
    Proprietary{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor(instanceIdUrl, null);
        }
    };

    private static String instanceIdUrl;
    private static String[] headers;

    public abstract String getInstanceId();

    public static void setInstanceIdUrl(String instanceIdUrl) {
        CloudProvider.instanceIdUrl = instanceIdUrl;
    }

    public static void setHeaders(String ... headers) {
        CloudProvider.headers = headers;
    }

    public String getInstanceIdIgnoreException() {
        try {
            return this.getInstanceId();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String instanceIdFor(String instanceIdUrl, String ... headers) {
        Objects.requireNonNull(instanceIdUrl);
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(new URI(instanceIdUrl));
            if (headers != null && headers.length > 0) {
                requestBuilder.headers(headers);
            }
            HttpRequest request = requestBuilder.GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

