/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.stream.Stream;
import javax0.license3j.hardware.CloudProvider;
import javax0.license3j.hardware.Network;

class HashCalculator {
    private final Network.Interface.Selector selector;

    HashCalculator(Network.Interface.Selector selector) {
        this.selector = selector;
    }

    private void updateWithNetworkData(MessageDigest md5, Stream<Network.Interface.Data> interfaces) {
        interfaces.forEach(ni -> {
            md5.update(ni.name.getBytes(StandardCharsets.UTF_8));
            if (ni.hwAddress != null) {
                md5.update(ni.hwAddress);
            }
        });
    }

    void updateWithNetworkData(MessageDigest md5) throws SocketException {
        Stream<Network.Interface.Data> networkInterfaces = Network.Interface.Data.gatherUsing(this.selector);
        this.updateWithNetworkData(md5, networkInterfaces.sorted(Comparator.comparing(a -> a.name)));
    }

    void updateWithHostName(MessageDigest md5) throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        this.update(md5, hostName);
    }

    void updateWithArchitecture(MessageDigest md5) {
        String architecture = System.getProperty("os.arch");
        this.update(md5, architecture);
    }

    void updateWithCloudInstanceId(MessageDigest md5, CloudProvider cloudProvider) {
        String instanceId = cloudProvider.getInstanceId();
        this.update(md5, instanceId);
    }

    private void update(MessageDigest md5, String input) {
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        md5.update(bytes, 0, bytes.length);
    }
}

