/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax0.license3j.License;
import javax0.license3j.io.ByteArrayReader;
import javax0.license3j.io.IOFormat;

public class LicenseReader
implements Closeable {
    private final InputStream is;
    final AtomicBoolean closed = new AtomicBoolean(false);

    public LicenseReader(InputStream is) {
        this.is = Objects.requireNonNull(is);
    }

    public LicenseReader(File file, long limit) throws FileNotFoundException {
        this(new FileInputStream(file));
        if (file.length() > limit) {
            throw new IllegalArgumentException("License file is too long.");
        }
    }

    public LicenseReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public LicenseReader(String fileName, long limit) throws FileNotFoundException {
        this(new File(fileName), limit);
    }

    public LicenseReader(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public License read() throws IOException {
        return this.read(IOFormat.BINARY);
    }

    public License read(IOFormat format) throws IOException {
        License license;
        switch (format) {
            case BINARY: {
                license = License.Create.from(ByteArrayReader.readInput(this.is));
                break;
            }
            case BASE64: {
                license = License.Create.from(Base64.getDecoder().decode(ByteArrayReader.readInput(this.is)));
                break;
            }
            case STRING: {
                license = License.Create.from(new String(ByteArrayReader.readInput(this.is), StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new IllegalArgumentException(IOFormat.class.getName() + " is incompatible with License3j, and was used with the value " + String.valueOf((Object)format) + " which is unknown");
            }
        }
        this.close();
        return license;
    }

    public License readChecking(IOFormat format) throws IOException {
        License license;
        switch (format) {
            case BINARY: {
                license = License.Create.from(ByteArrayReader.readInput(this.is, License.MAGIC_BYTES));
                break;
            }
            case BASE64: {
                license = License.Create.from(Base64.getDecoder().decode(ByteArrayReader.readInput(this.is, License.MAGIC_BASE64)));
                break;
            }
            default: {
                throw new IllegalArgumentException(IOFormat.class.getName() + " is incompatible with License3j, and was used with the value " + String.valueOf((Object)format) + " which is unknown and/or cannot be used with readCheking");
            }
        }
        this.close();
        return license;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.is.close();
        }
    }
}

