/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.filtering;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.jmap.api.filtering.Rule;

public class RuleDTO {
    private final String id;
    private final String name;
    private final ConditionDTO conditionDTO;
    private final ActionDTO actionDTO;

    public static ImmutableList<Rule> toRules(List<RuleDTO> ruleDTOList) {
        Preconditions.checkNotNull(ruleDTOList);
        return (ImmutableList)ruleDTOList.stream().map(RuleDTO::toRule).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<RuleDTO> from(List<Rule> rules) {
        Preconditions.checkNotNull(rules);
        return (ImmutableList)rules.stream().map(RuleDTO::from).collect(ImmutableList.toImmutableList());
    }

    public static RuleDTO from(Rule rule) {
        return new RuleDTO(rule.getId().asString(), rule.getName(), ConditionDTO.from(rule.getCondition()), ActionDTO.from(rule.getAction()));
    }

    @JsonCreator
    public RuleDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="condition") ConditionDTO conditionDTO, @JsonProperty(value="action") ActionDTO actionDTO) {
        this.name = name;
        this.conditionDTO = conditionDTO;
        this.actionDTO = actionDTO;
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ConditionDTO getCondition() {
        return this.conditionDTO;
    }

    public ActionDTO getAction() {
        return this.actionDTO;
    }

    public Rule toRule() {
        return Rule.builder().id(Rule.Id.of((String)this.id)).name(this.name).condition(this.conditionDTO.toCondition()).name(this.name).action(this.actionDTO.toAction()).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof RuleDTO) {
            RuleDTO ruleDTO = (RuleDTO)o;
            return Objects.equals(this.id, ruleDTO.id) && Objects.equals(this.name, ruleDTO.name) && Objects.equals(this.conditionDTO, ruleDTO.conditionDTO) && Objects.equals(this.actionDTO, ruleDTO.actionDTO);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.conditionDTO, this.actionDTO);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class ConditionDTO {
        private final String field;
        private final String comparator;
        private final String value;

        public static ConditionDTO from(Rule.Condition condition) {
            return new ConditionDTO(condition.getField().asString(), condition.getComparator().asString(), condition.getValue());
        }

        @JsonCreator
        public ConditionDTO(@JsonProperty(value="field") String field, @JsonProperty(value="comparator") String comparator, @JsonProperty(value="value") String value) {
            this.field = field;
            this.comparator = comparator;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public String getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        public Rule.Condition toCondition() {
            return Rule.Condition.of((Rule.Condition.Field)Rule.Condition.Field.of((String)this.field), (Rule.Condition.Comparator)Rule.Condition.Comparator.of((String)this.comparator), (String)this.value);
        }

        public final boolean equals(Object o) {
            if (o instanceof ConditionDTO) {
                ConditionDTO other = (ConditionDTO)o;
                return Objects.equals(this.field, other.field) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.value, other.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.field, this.comparator, this.value);
        }
    }

    public static class ActionDTO {
        private final AppendInMailboxesDTO appendIn;

        public static ActionDTO from(Rule.Action action) {
            return new ActionDTO(AppendInMailboxesDTO.from(action.getAppendInMailboxes()));
        }

        @JsonCreator
        public ActionDTO(@JsonProperty(value="appendIn") AppendInMailboxesDTO appendIn) {
            this.appendIn = appendIn;
        }

        public AppendInMailboxesDTO getAppendIn() {
            return this.appendIn;
        }

        public Rule.Action toAction() {
            return Rule.Action.of((Rule.Action.AppendInMailboxes)this.appendIn.toAppendInMailboxes());
        }

        public final boolean equals(Object o) {
            if (o instanceof ActionDTO) {
                ActionDTO actionDTO = (ActionDTO)o;
                return Objects.equals(this.appendIn, actionDTO.appendIn);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.appendIn);
        }

        public static class AppendInMailboxesDTO {
            private final List<String> mailboxIds;

            public static AppendInMailboxesDTO from(Rule.Action.AppendInMailboxes appendInMailboxes) {
                return new AppendInMailboxesDTO((List<String>)appendInMailboxes.getMailboxIds());
            }

            @JsonCreator
            public AppendInMailboxesDTO(@JsonProperty(value="mailboxIds") List<String> mailboxIds) {
                this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            }

            public List<String> getMailboxIds() {
                return this.mailboxIds;
            }

            public Rule.Action.AppendInMailboxes toAppendInMailboxes() {
                return Rule.Action.AppendInMailboxes.withMailboxIds(this.mailboxIds);
            }

            public final boolean equals(Object o) {
                if (o instanceof AppendInMailboxesDTO) {
                    AppendInMailboxesDTO that = (AppendInMailboxesDTO)o;
                    return Objects.equals(this.mailboxIds, that.mailboxIds);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.mailboxIds);
            }
        }
    }
}

