/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.savignano.uptrust.proxy.imap.decode.AppendProxyCommandParser;
import net.savignano.uptrust.proxy.imap.decode.CapabilityProxyCommandParser;
import net.savignano.uptrust.proxy.imap.decode.FetchProxyCommandParser;
import net.savignano.uptrust.proxy.imap.decode.IdleProxyCommandParser;
import net.savignano.uptrust.proxy.imap.decode.ProxyCommandParser;
import net.savignano.uptrust.proxy.imap.decode.UidProxyCommandParser;
import net.savignano.uptrust.service.IUptrustService;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapDecoderFactory;
import org.apache.james.imap.decode.main.DefaultImapDecoder;
import org.apache.james.imap.decode.parser.StartTLSCommandParser;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;

public class ProxyImapDecoderFactory
implements ImapDecoderFactory {
    private final IUptrustService uptrustService;

    public static final ImapDecoder createDecoder(IUptrustService uptrustService) {
        UnpooledStatusResponseFactory unpooledStatusResponseFactory = new UnpooledStatusResponseFactory();
        ProxyParserFactory proxyParserFactory = new ProxyParserFactory(uptrustService, (StatusResponseFactory)unpooledStatusResponseFactory);
        return new DefaultImapDecoder((StatusResponseFactory)unpooledStatusResponseFactory, (ImapCommandParserFactory)proxyParserFactory);
    }

    public ProxyImapDecoderFactory(IUptrustService uptrustService) {
        this.uptrustService = uptrustService;
    }

    public ImapDecoder buildImapDecoder() {
        return ProxyImapDecoderFactory.createDecoder(this.uptrustService);
    }

    private static final class ProxyParserFactory
    implements ImapCommandParserFactory {
        private final StatusResponseFactory statusResponseFactory;
        private final Map<String, ImapCommandParser> parsers;

        public ProxyParserFactory(IUptrustService uptrustService, StatusResponseFactory statusResponseFactory) {
            this.statusResponseFactory = statusResponseFactory;
            this.parsers = new HashMap<String, ImapCommandParser>();
            if (!uptrustService.isDisabled()) {
                this.parsers.put(ImapConstants.APPEND_COMMAND.getName(), (ImapCommandParser)new AppendProxyCommandParser(statusResponseFactory));
                this.parsers.put(ImapConstants.FETCH_COMMAND.getName(), (ImapCommandParser)new FetchProxyCommandParser(statusResponseFactory));
                this.parsers.put(ImapConstants.UID_COMMAND.getName(), (ImapCommandParser)new UidProxyCommandParser(this, statusResponseFactory));
                this.parsers.put(ImapConstants.IDLE_COMMAND.getName(), (ImapCommandParser)new IdleProxyCommandParser(statusResponseFactory));
            }
            this.parsers.put(ImapConstants.CAPABILITY_COMMAND.getName(), (ImapCommandParser)new CapabilityProxyCommandParser(statusResponseFactory));
            this.parsers.put(ImapConstants.STARTTLS_COMMAND.getName(), (ImapCommandParser)new StartTLSCommandParser(statusResponseFactory));
        }

        public ImapCommandParser getParser(String commandName) {
            String upperCaseCommand = commandName.toUpperCase(Locale.ROOT);
            Object parser = this.parsers.get(upperCaseCommand);
            if (parser == null) {
                parser = new ProxyCommandParser(upperCaseCommand, this.statusResponseFactory);
                this.parsers.put(upperCaseCommand, (ImapCommandParser)parser);
            }
            return parser;
        }
    }
}

