/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.savignano.uptrust.proxy.imap.encode.ProxyResponseEncoder;
import net.savignano.uptrust.proxy.imap.encode.fetch.FetchProxyResponseEncoder;
import net.savignano.uptrust.service.IUptrustService;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapEncoderFactory;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.encode.StatusResponseEncoder;
import org.apache.james.imap.encode.base.EndImapEncoder;
import org.apache.james.imap.encode.main.DefaultLocalizer;

public class ProxyImapEncoderFactory
implements ImapEncoderFactory {
    private final IUptrustService uptrustService;
    private final Localizer localizer;

    public static final ImapEncoder createEncoder(IUptrustService uptrustService, Localizer localizer) {
        return ProxyImapEncoderFactory.create(uptrustService, (Localizer)(localizer != null ? localizer : new DefaultLocalizer()));
    }

    private static final ImapEncoder create(IUptrustService uptrustService, Localizer localizer) {
        Stream<ImapResponseEncoder<?>> encoders = uptrustService.isDisabled() ? ProxyImapEncoderFactory.createDisabledEncoder(localizer) : ProxyImapEncoderFactory.createProxyEncoder(localizer);
        return new DefaultImapEncoder(encoders, new EndImapEncoder());
    }

    private static Stream<ImapResponseEncoder<?>> createProxyEncoder(Localizer localizer) {
        return Stream.of(new FetchProxyResponseEncoder(), new ProxyResponseEncoder(), new StatusResponseEncoder(localizer));
    }

    private static Stream<ImapResponseEncoder<?>> createDisabledEncoder(Localizer localizer) {
        return Stream.of(new ProxyResponseEncoder(), new StatusResponseEncoder(localizer));
    }

    public ProxyImapEncoderFactory(IUptrustService uptrustService) {
        this(uptrustService, (Localizer)new DefaultLocalizer());
    }

    public ProxyImapEncoderFactory(IUptrustService uptrustService, Localizer localizer) {
        this.uptrustService = uptrustService;
        this.localizer = localizer;
    }

    public ImapEncoder buildImapEncoder() {
        return ProxyImapEncoderFactory.createEncoder(this.uptrustService, this.localizer);
    }

    private static class DefaultImapEncoder
    implements ImapEncoder {
        private final Map<Class<? extends ImapMessage>, ImapResponseEncoder<?>> encoders;
        private final EndImapEncoder endImapEncoder;

        private DefaultImapEncoder(Stream<ImapResponseEncoder<?>> encoders, EndImapEncoder endImapEncoder) {
            this.encoders = (Map)encoders.collect(ImmutableMap.toImmutableMap(ImapResponseEncoder::acceptableMessages, Function.identity()));
            this.endImapEncoder = endImapEncoder;
        }

        public void encode(ImapMessage message, ImapResponseComposer composer) throws IOException {
            ImapResponseEncoder<?> imapResponseEncoder = this.encoders.get(message.getClass());
            if (imapResponseEncoder != null) {
                imapResponseEncoder.encode(message, composer);
            } else {
                this.endImapEncoder.encode(message, composer);
            }
        }
    }
}

