/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap;

import java.util.function.Predicate;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.base.handler.IMailHandler;
import net.savignano.uptrust.proxy.base.handler.incoming.IncomingMailHandler;
import net.savignano.uptrust.proxy.base.handler.incoming.IncomingMailHandlerBuilder;
import net.savignano.uptrust.proxy.imap.processor.CapabilityProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.GeneralProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.IdleProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.LogoutProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.append.AppendMailHandler;
import net.savignano.uptrust.proxy.imap.processor.append.AppendMailHandlerBuilder;
import net.savignano.uptrust.proxy.imap.processor.append.AppendProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.fetch.FetchProxyProcessor;
import net.savignano.uptrust.service.IUptrustService;
import net.savignano.uptrust.service.cryptography.IDecryptionService;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;
import org.apache.james.imap.processor.StartTLSProcessor;
import org.apache.james.imap.processor.base.ImapResponseMessageProcessor;
import org.apache.james.imap.processor.base.UnknownRequestProcessor;
import org.slf4j.LoggerFactory;

public class ProxyImapProcessorFactory {
    private static final String INCOMING_MAIL_HANDLER_KEY = "incomingMail";
    private static final String OUTGOING_MAIL_HANDLER_KEY = "outgoingMail";

    public static final ImapProcessor createProcessor(IUptrustService service) {
        LoggerFactory.getLogger(ProxyImapProcessorFactory.class).info("Creating proxy processor for IMAP.");
        if (service.isDisabled()) {
            LoggerFactory.getLogger(ProxyImapProcessorFactory.class).info("Uptrust is disabled.");
            return ProxyImapProcessorFactory.createDisabledProcessor();
        }
        return ProxyImapProcessorFactory.createProxyProcessor(service);
    }

    private static ImapProcessor createProxyProcessor(IUptrustService service) {
        IncomingMailHandler incomingMailHandler = ProxyImapProcessorFactory.buildIncomingMailHandler(service);
        AppendMailHandler appendMailHandler = ProxyImapProcessorFactory.buildAppendMailHandler(service);
        UnpooledStatusResponseFactory statusResponseFactory = new UnpooledStatusResponseFactory();
        UnknownRequestProcessor unknownRequestImapProcessor = new UnknownRequestProcessor((StatusResponseFactory)statusResponseFactory);
        GeneralProxyProcessor proxyGeneralProcessor = new GeneralProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)unknownRequestImapProcessor);
        AppendProxyProcessor proxyAppendProcessor = new AppendProxyProcessor(service.getSession(), appendMailHandler, (StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyGeneralProcessor);
        FetchProxyProcessor proxyFetchProcessor = new FetchProxyProcessor(service.getSession(), (IMailHandler)incomingMailHandler, (StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyAppendProcessor);
        CapabilityProxyProcessor proxyCapabilityProcessor = new CapabilityProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyFetchProcessor);
        IdleProxyProcessor proxyIdleProcessor = new IdleProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyCapabilityProcessor);
        LogoutProxyProcessor proxyLogoutProcessor = new LogoutProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyIdleProcessor);
        StartTLSProcessor startTlsProcessor = new StartTLSProcessor((ImapProcessor)proxyLogoutProcessor, (StatusResponseFactory)statusResponseFactory);
        return new ImapResponseMessageProcessor((ImapProcessor)startTlsProcessor);
    }

    private static ImapProcessor createDisabledProcessor() {
        UnpooledStatusResponseFactory statusResponseFactory = new UnpooledStatusResponseFactory();
        UnknownRequestProcessor unknownRequestImapProcessor = new UnknownRequestProcessor((StatusResponseFactory)statusResponseFactory);
        GeneralProxyProcessor proxyGeneralProcessor = new GeneralProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)unknownRequestImapProcessor);
        CapabilityProxyProcessor proxyCapabilityProcessor = new CapabilityProxyProcessor((StatusResponseFactory)statusResponseFactory, (ImapProcessor)proxyGeneralProcessor);
        StartTLSProcessor startTlsProcessor = new StartTLSProcessor((ImapProcessor)proxyCapabilityProcessor, (StatusResponseFactory)statusResponseFactory);
        return new ImapResponseMessageProcessor((ImapProcessor)startTlsProcessor);
    }

    private static final IncomingMailHandler buildIncomingMailHandler(IUptrustService service) {
        return IncomingMailHandlerBuilder.from((ImmutableConfiguration)service.getConfig().configurationAt(INCOMING_MAIL_HANDLER_KEY)).checkLicenseWith(service.getLicenseService()).decryptWith(service.getDecryptionService()).validateWith(service.getValidationService()).extractWith(service.getExtractionService()).decorateWith(service.getDecoratorService()).keyService(service.getKeyService()).build();
    }

    private static final AppendMailHandler buildAppendMailHandler(IUptrustService service) {
        return AppendMailHandlerBuilder.from((ImmutableConfiguration)service.getConfig().configurationAt(OUTGOING_MAIL_HANDLER_KEY)).checkLicenseWith(service.getLicenseService()).encryptWith(service.getEncryptionService()).detectCrypto(arg_0 -> ((IUptrustService)service).determineCryptography(arg_0)).detectEncryption(ProxyImapProcessorFactory.getDetectEncPred(service.getDecryptionService())).build();
    }

    private static final Predicate<MimeMessage> getDetectEncPred(IDecryptionService service) {
        return service == null ? msg -> false : arg_0 -> ((IDecryptionService)service).isEncrypted(arg_0);
    }
}

