/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.decode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.savignano.uptrust.proxy.imap.request.AppendProxyRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;

public class AppendProxyCommandParser
extends AbstractImapCommandParser {
    private static final Pattern APPEND_PATTERN = Pattern.compile("\\{(\\d+)(\\+)?\\}");

    public AppendProxyCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapCommand.anyStateCommand((String)"PROXY_APPEND"), statusResponseFactory);
    }

    protected ImapMessage decode(ImapRequestLineReader reader, Tag tag, ImapSession session) throws DecodingException {
        String rest = StringUtils.stripToNull((String)reader.line());
        Matcher matcher = APPEND_PATTERN.matcher(rest);
        if (!matcher.find()) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Could not parse size.");
        }
        int size = Integer.parseInt(matcher.group(1));
        boolean synched = matcher.group(2) == null;
        AppendProxyRequest request = new AppendProxyRequest(tag, rest);
        request.setRemainingData(size);
        request.setSynched(synched);
        request.setExpectingServerData(synched);
        return request;
    }
}

