/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.decode;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.savignano.uptrust.proxy.imap.request.FetchProxyRequest;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.FetchPartPathDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;

public class FetchProxyCommandParser
extends AbstractImapCommandParser {
    private static final String CHANGEDSINCE = "CHANGEDSINCE";
    private static final String VANISHED = "VANISHED";

    public FetchProxyCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapCommand.anyStateCommand((String)"PROXY_FETCH"), statusResponseFactory);
    }

    private FetchData fetchRequest(ImapRequestLineReader request, boolean useUid) throws DecodingException {
        FetchData.Builder fetch = FetchData.builder();
        if (useUid) {
            fetch.fetch(new FetchData.Item[]{FetchData.Item.UID});
        }
        char next = this.nextNonSpaceChar(request);
        if (request.nextChar() == '(') {
            request.consumeChar('(');
            next = this.nextNonSpaceChar(request);
            while (next != ')') {
                this.addNextElement(request, fetch);
                next = this.nextNonSpaceChar(request);
            }
            request.consumeChar(')');
            next = this.nextNonSpaceChar(request);
            if (next == '(') {
                request.consumeChar('(');
                next = request.nextChar();
                switch (next) {
                    case 'C': {
                        request.consumeWord((ImapRequestLineReader.CharacterValidator)ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase((String)CHANGEDSINCE));
                        fetch.changedSince(request.number(true));
                        break;
                    }
                    case 'V': {
                        request.consumeWord((ImapRequestLineReader.CharacterValidator)ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase((String)VANISHED));
                        fetch.vanished(true);
                        break;
                    }
                }
                request.consumeChar(')');
            }
        } else {
            this.addNextElement(request, fetch);
        }
        return fetch.build();
    }

    private void addNextElement(ImapRequestLineReader reader, FetchData.Builder fetch) throws DecodingException {
        String name = this.readWord(reader, " [)\r\n");
        char next = reader.nextChar();
        if (next != '[') {
            this.addNextName(fetch, name);
        } else {
            Long numberOfOctets;
            Long firstOctet;
            reader.consumeChar('[');
            String parameter = this.readWord(reader, "]");
            reader.consumeChar(']');
            if (reader.nextChar() == '<') {
                reader.consumeChar('<');
                firstOctet = reader.number();
                if (reader.nextChar() == '.') {
                    reader.consumeChar('.');
                    numberOfOctets = reader.nzNumber();
                } else {
                    numberOfOctets = null;
                }
                reader.consumeChar('>');
            } else {
                firstOctet = null;
                numberOfOctets = null;
            }
            BodyFetchElement bodyFetchElement = this.createBodyElement(parameter, firstOctet, numberOfOctets);
            boolean isPeek = this.isPeek(name);
            fetch.add(bodyFetchElement, isPeek);
        }
    }

    private FetchData.Builder addNextName(FetchData.Builder fetch, String name) throws DecodingException {
        String capitalizedName;
        switch (capitalizedName = name.toUpperCase(Locale.US)) {
            case "FAST": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE});
            }
            case "FULL": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE, FetchData.Item.ENVELOPE, FetchData.Item.BODY});
            }
            case "ALL": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE, FetchData.Item.ENVELOPE});
            }
            case "FLAGS": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.FLAGS});
            }
            case "RFC822.SIZE": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.SIZE});
            }
            case "ENVELOPE": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.ENVELOPE});
            }
            case "INTERNALDATE": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.INTERNAL_DATE});
            }
            case "BODY": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.BODY});
            }
            case "BODYSTRUCTURE": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.BODY_STRUCTURE});
            }
            case "UID": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.UID});
            }
            case "RFC822": {
                return fetch.add(BodyFetchElement.createRFC822(), false);
            }
            case "RFC822.HEADER": {
                return fetch.add(BodyFetchElement.createRFC822Header(), true);
            }
            case "RFC822.TEXT": {
                return fetch.add(BodyFetchElement.createRFC822Text(), false);
            }
            case "MODSEQ": {
                return fetch.fetch(new FetchData.Item[]{FetchData.Item.MODSEQ});
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attribute: " + name);
    }

    private boolean isPeek(String name) throws DecodingException {
        switch (name.toUpperCase(Locale.US)) {
            case "BODY": {
                return false;
            }
            case "BODY.PEEK": {
                return true;
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attibute: " + name + "[]");
    }

    private BodyFetchElement createBodyElement(String parameter, Long firstOctet, Long numberOfOctets) throws DecodingException {
        String responseName = "BODY[" + parameter + "]";
        FetchPartPathDecoder decoder = new FetchPartPathDecoder();
        decoder.decode((CharSequence)parameter);
        SectionType sectionType = decoder.getSpecifier();
        List names = decoder.getNames();
        int[] path = decoder.getPath();
        return new BodyFetchElement(responseName, sectionType, path, (Collection)names, firstOctet, numberOfOctets);
    }

    private String readWord(ImapRequestLineReader request, String terminator) throws DecodingException {
        StringBuilder builder = new StringBuilder();
        char next = request.nextChar();
        while (terminator.indexOf(next) == -1) {
            builder.append(next);
            request.consume();
            next = request.nextChar();
        }
        return builder.toString();
    }

    private char nextNonSpaceChar(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextChar();
        while (next == ' ') {
            request.consume();
            next = request.nextChar();
        }
        return next;
    }

    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        return this.decode(request, tag, false, session);
    }

    ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] idSet = request.parseIdRange(session);
        FetchData fetch = this.fetchRequest(request, useUids);
        if (fetch.getVanished() && !useUids) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "VANISHED only allowed in UID FETCH");
        }
        request.eol();
        FetchProxyRequest proxyFetchRequest = new FetchProxyRequest(tag);
        proxyFetchRequest.setUseUids(useUids);
        proxyFetchRequest.setIdSet(idSet);
        proxyFetchRequest.setFetch(fetch);
        return proxyFetchRequest;
    }
}

