/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.decode;

import net.savignano.uptrust.proxy.imap.decode.FetchProxyCommandParser;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidProxyCommandParser
extends AbstractImapCommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UidProxyCommandParser.class);
    private final ImapCommandParserFactory parserFactory;

    public UidProxyCommandParser(ImapCommandParserFactory parserFactory, StatusResponseFactory statusResponseFactory) {
        super(ImapCommand.anyStateCommand((String)"PROXY_UID"), statusResponseFactory);
        this.parserFactory = parserFactory;
    }

    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String commandName = request.atom();
        LOGGER.debug("Got <command>: UID {}", (Object)commandName);
        ImapCommandParser helperCommand = this.parserFactory.getParser(commandName);
        if (helperCommand instanceof FetchProxyCommandParser) {
            return ((FetchProxyCommandParser)helperCommand).decode(request, tag, true, session);
        }
        String rest = request.line();
        return new ProxyRequest(tag, "UID", commandName + rest);
    }
}

