/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.util.io.InputStreamConsummer;

public final class CountingInputStream
extends InputStream {
    private final InputStream in;
    private int lineCount;
    private int octetCount;

    public CountingInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int next = this.in.read();
        if (next > 0) {
            ++this.octetCount;
            if (next == 13) {
                ++this.lineCount;
            }
        }
        return next;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.octetCount += read;
            for (int i = off; i < off + read; ++i) {
                if (b[i] != 13) continue;
                ++this.lineCount;
            }
        }
        return read;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getOctetCount() {
        return this.octetCount;
    }

    public void readAll() throws IOException {
        InputStreamConsummer.consume((InputStream)this);
    }
}

