/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.util.Collection;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MimePath;

public class FetchDataConverter {
    public static FetchGroup getFetchGroup(FetchData fetch) {
        Collection bodyElements;
        FetchGroup result = FetchGroup.MINIMAL;
        if (fetch.contains(FetchData.Item.ENVELOPE)) {
            result = (FetchGroup)result.with(new FetchGroup.Profile[]{FetchGroup.Profile.HEADERS});
        }
        if (fetch.contains(FetchData.Item.BODY) || fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
            result = (FetchGroup)result.with(new FetchGroup.Profile[]{FetchGroup.Profile.MIME_DESCRIPTOR});
        }
        if ((bodyElements = fetch.getBodyElements()) != null) {
            for (BodyFetchElement element : bodyElements) {
                SectionType sectionType = element.getSectionType();
                int[] path = element.getPath();
                boolean isBase = path == null || path.length == 0;
                switch (sectionType) {
                    case CONTENT: {
                        if (isBase) {
                            result = FetchDataConverter.addContent(result, path, isBase, FetchGroup.Profile.FULL_CONTENT);
                            break;
                        }
                        result = FetchDataConverter.addContent(result, path, isBase, FetchGroup.Profile.MIME_CONTENT);
                        break;
                    }
                    case HEADER: 
                    case HEADER_NOT_FIELDS: 
                    case HEADER_FIELDS: {
                        result = FetchDataConverter.addContent(result, path, isBase, FetchGroup.Profile.HEADERS);
                        break;
                    }
                    case MIME: {
                        result = FetchDataConverter.addContent(result, path, isBase, FetchGroup.Profile.MIME_HEADERS);
                        break;
                    }
                    case TEXT: {
                        result = FetchDataConverter.addContent(result, path, isBase, FetchGroup.Profile.BODY_CONTENT);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static FetchGroup addContent(FetchGroup result, int[] path, boolean isBase, FetchGroup.Profile profile) {
        if (isBase) {
            return (FetchGroup)result.with(new FetchGroup.Profile[]{profile});
        }
        MimePath mimePath = new MimePath(path);
        return result.addPartContent(mimePath, new FetchGroup.Profile[]{profile});
    }
}

