/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.imap.encode.fetch.EnvelopeBuilder;
import net.savignano.uptrust.proxy.imap.encode.fetch.FetchDataConverter;
import net.savignano.uptrust.proxy.imap.encode.fetch.FetchResponseBuilder;
import net.savignano.uptrust.proxy.imap.encode.fetch.ProxyMessageResult;
import net.savignano.uptrust.proxy.imap.response.FetchProxyResponse;
import org.apache.james.imap.encode.FetchResponseEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProxyResponseEncoder
implements ImapResponseEncoder<FetchProxyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(FetchProxyResponseEncoder.class);

    public Class<FetchProxyResponse> acceptableMessages() {
        return FetchProxyResponse.class;
    }

    public void encode(FetchProxyResponse message, ImapResponseComposer composer) throws IOException {
        this.encodeFetch(message, composer);
        this.encodeAdditional(message, composer);
    }

    private void encodeFetch(FetchProxyResponse response, ImapResponseComposer composer) throws IOException {
        Set<MessageSequenceNumber> msns;
        FetchGroup fetchGroup = FetchDataConverter.getFetchGroup(response.getFetchData());
        FetchResponseBuilder builder = new FetchResponseBuilder(new EnvelopeBuilder());
        FetchResponseEncoder encoder = new FetchResponseEncoder(false);
        Map<MessageSequenceNumber, MimeMessage> messages = response.getMessages();
        Map<MessageSequenceNumber, MessageMetaData> metaDatas = response.getMetadata();
        if (messages.isEmpty()) {
            msns = metaDatas.keySet();
        } else if (metaDatas.isEmpty()) {
            msns = messages.keySet();
        } else {
            msns = messages.keySet();
            if (messages.size() != metaDatas.size()) {
                List msgMsns = messages.keySet().stream().map(msn -> msn.asInt()).collect(Collectors.toList());
                List dataMsns = metaDatas.keySet().stream().map(msn -> msn.asInt()).collect(Collectors.toList());
                LOG.warn("Expected same amount of messages and their corresponding metadata. Message sequence numbers for messages/metadata: {} / {}", msgMsns, dataMsns);
            }
        }
        for (MessageSequenceNumber msn2 : msns) {
            MimeMessage message = messages.get(msn2);
            MessageMetaData metaData = metaDatas.get(msn2);
            ProxyMessageResult result = new ProxyMessageResult(message, metaData);
            result.setFetchGroup(fetchGroup);
            FetchResponse fetchResponse = builder.build(response.getFetchData(), result, msn2);
            encoder.encode(fetchResponse, composer);
        }
    }

    private void encodeAdditional(FetchProxyResponse response, ImapResponseComposer composer) throws IOException {
        for (String line : response.getAdditionalLines()) {
            composer.skipNextSpace();
            composer.message(line);
            composer.end();
        }
    }
}

