/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import net.savignano.uptrust.proxy.imap.encode.fetch.ContentBodyElement;
import net.savignano.uptrust.proxy.imap.encode.fetch.EmptyContent;
import net.savignano.uptrust.proxy.imap.encode.fetch.EnvelopeBuilder;
import net.savignano.uptrust.proxy.imap.encode.fetch.HeaderBodyElement;
import net.savignano.uptrust.proxy.imap.encode.fetch.HeadersBodyElement;
import net.savignano.uptrust.proxy.imap.encode.fetch.MessageResultUtils;
import net.savignano.uptrust.proxy.imap.encode.fetch.MimeBodyElement;
import net.savignano.uptrust.proxy.imap.encode.fetch.MimeDescriptorStructure;
import net.savignano.uptrust.proxy.imap.encode.fetch.PartialFetchBodyElement;
import net.savignano.uptrust.proxy.imap.encode.fetch.ProxyMessageResult;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MimePath;

public final class FetchResponseBuilder {
    private final EnvelopeBuilder envelopeBuilder;
    private MessageSequenceNumber msn;
    private MessageUid uid;
    private Flags flags;
    private Date internalDate;
    private Long size;
    private ModSeq modSeq;
    private List<FetchResponse.BodyElement> elements;
    private FetchResponse.Envelope envelope;
    private FetchResponse.Structure body;
    private FetchResponse.Structure bodystructure;

    public FetchResponseBuilder(EnvelopeBuilder envelopeBuilder) {
        this.envelopeBuilder = envelopeBuilder;
    }

    public void reset(MessageSequenceNumber msn) {
        this.msn = msn;
        this.uid = null;
        this.flags = null;
        this.internalDate = null;
        this.size = null;
        this.body = null;
        this.bodystructure = null;
        this.elements = null;
        this.modSeq = null;
    }

    public void setUid(MessageUid resultUid) {
        this.uid = resultUid;
    }

    private void setModSeq(ModSeq modSeq) {
        this.modSeq = modSeq;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public FetchResponse build() {
        return new FetchResponse(this.msn, this.flags, this.uid, this.modSeq, this.internalDate, this.size, this.envelope, this.body, this.bodystructure, this.elements);
    }

    public FetchResponse build(FetchData fetch, ProxyMessageResult result, MessageSequenceNumber msn) throws IOException {
        MessageUid resultUid = result.getUid();
        this.reset(msn);
        this.setFlags(result.getFlags());
        if (fetch.contains(FetchData.Item.INTERNAL_DATE)) {
            this.setInternalDate(result.getInternalDate());
        }
        if (fetch.contains(FetchData.Item.SIZE)) {
            this.setSize(result.getSize());
        }
        if (fetch.contains(FetchData.Item.ENVELOPE)) {
            this.envelope = this.buildEnvelope(result);
        }
        Collection elements = fetch.getBodyElements();
        this.elements = new ArrayList<FetchResponse.BodyElement>();
        for (BodyFetchElement fetchElement : elements) {
            FetchResponse.BodyElement element = this.bodyFetch(result, fetchElement);
            if (element == null) continue;
            this.elements.add(element);
        }
        if (fetch.contains(FetchData.Item.BODY) || fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
            if (fetch.contains(FetchData.Item.BODY) && this.elements.isEmpty()) {
                this.body = new MimeDescriptorStructure(false, result.getMimeDescriptor(), this.envelopeBuilder);
            }
            if (fetch.contains(FetchData.Item.BODY_STRUCTURE)) {
                this.bodystructure = new MimeDescriptorStructure(true, result.getMimeDescriptor(), this.envelopeBuilder);
            }
        }
        this.addUid(fetch, resultUid);
        this.addModSeq(fetch, result.getModSeq());
        return this.build();
    }

    private void addUid(FetchData fetch, MessageUid resultUid) {
        if (fetch.contains(FetchData.Item.UID)) {
            this.setUid(resultUid);
        }
    }

    private void addModSeq(FetchData fetch, ModSeq modSeq) {
        if (fetch.contains(FetchData.Item.MODSEQ)) {
            long changedSince = fetch.getChangedSince();
            if (changedSince != -1L) {
                if (changedSince < modSeq.asLong()) {
                    this.setModSeq(modSeq);
                }
            } else {
                this.setModSeq(modSeq);
            }
        }
    }

    private FetchResponse.Envelope buildEnvelope(ProxyMessageResult result) {
        return this.envelopeBuilder.buildEnvelope(result.getHeaders());
    }

    private void setSize(long size) {
        this.size = size;
    }

    public void setInternalDate(Date internalDate) {
        this.internalDate = internalDate;
    }

    private FetchResponse.BodyElement bodyFetch(ProxyMessageResult messageResult, BodyFetchElement fetchElement) throws IOException {
        Long firstOctet = fetchElement.getFirstOctet();
        Long numberOfOctets = fetchElement.getNumberOfOctets();
        String name = fetchElement.getResponseName();
        SectionType specifier = fetchElement.getSectionType();
        Optional<MimePath> path = Optional.ofNullable(fetchElement.getPath()).filter(paths -> ((int[])paths).length > 0).map(MimePath::new);
        Collection names = fetchElement.getFieldNames();
        FetchResponse.BodyElement fullResult = this.bodyContent(messageResult, name, specifier, path, names);
        return this.wrapIfPartialFetch(firstOctet, numberOfOctets, fullResult);
    }

    private FetchResponse.BodyElement bodyContent(ProxyMessageResult messageResult, String name, SectionType specifier, Optional<MimePath> path, Collection<String> names) throws IOException {
        switch (specifier) {
            case CONTENT: {
                return this.content(messageResult, name, path);
            }
            case HEADER_FIELDS: {
                return this.fields(messageResult, name, path, names);
            }
            case HEADER_NOT_FIELDS: {
                return this.fieldsNot(messageResult, name, path, names);
            }
            case MIME: {
                return this.mimeHeaders(messageResult, name, path);
            }
            case HEADER: {
                return this.headers(messageResult, name, path);
            }
            case TEXT: {
                return this.text(messageResult, name, path);
            }
        }
        return null;
    }

    private FetchResponse.BodyElement wrapIfPartialFetch(Long firstOctet, Long numberOfOctets, FetchResponse.BodyElement fullResult) {
        if (firstOctet == null) {
            return fullResult;
        }
        Optional<Long> numberOfOctetsAsLong = Optional.ofNullable(numberOfOctets);
        long firstOctetAsLong = firstOctet;
        return new PartialFetchBodyElement(fullResult, firstOctetAsLong, numberOfOctetsAsLong);
    }

    private FetchResponse.BodyElement text(ProxyMessageResult messageResult, String name, Optional<MimePath> path) throws IOException {
        Content body = Optional.ofNullable(this.getTextContent(messageResult, path)).orElseGet(EmptyContent::new);
        return new ContentBodyElement(name, body);
    }

    private Content getTextContent(ProxyMessageResult messageResult, Optional<MimePath> path) throws IOException {
        if (path.isEmpty()) {
            return messageResult.getBody();
        }
        return messageResult.getBody(path.get());
    }

    private FetchResponse.BodyElement mimeHeaders(ProxyMessageResult messageResult, String name, Optional<MimePath> path) {
        Iterator<Header> headers = this.getMimeHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getAll(headers);
        return new MimeBodyElement(name, lines);
    }

    private HeaderBodyElement headerBodyElement(ProxyMessageResult messageResult, String name, List<Header> lines, Optional<MimePath> path) throws IOException {
        HeaderBodyElement result = new HeaderBodyElement(name, lines);
        if (result.size() == 2L) {
            if (path.isEmpty()) {
                if (messageResult.getSize() - result.size() <= 0L) {
                    result.noBody();
                }
            } else if (this.content(messageResult, name, path).size() <= 0L) {
                result.noBody();
            }
        }
        return result;
    }

    private FetchResponse.BodyElement headers(ProxyMessageResult messageResult, String name, Optional<MimePath> path) throws IOException {
        if (path.isEmpty()) {
            HeadersBodyElement element = new HeadersBodyElement(name, (Content)messageResult.getHeaders());
            if (messageResult.getSize() - element.size() <= 0L) {
                element.noBody();
            }
            return element;
        }
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getAll(headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private FetchResponse.BodyElement fieldsNot(ProxyMessageResult messageResult, String name, Optional<MimePath> path, Collection<String> names) throws IOException {
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getNotMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private FetchResponse.BodyElement fields(ProxyMessageResult messageResult, String name, Optional<MimePath> path, Collection<String> names) throws IOException {
        Iterator<Header> headers = this.getHeaders(messageResult, path);
        List<Header> lines = MessageResultUtils.getMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path);
    }

    private Iterator<Header> getHeaders(ProxyMessageResult messageResult, Optional<MimePath> path) {
        if (path.isEmpty()) {
            return messageResult.getHeaders().headers();
        }
        return messageResult.iterateHeaders(path.get());
    }

    private Iterator<Header> getMimeHeaders(ProxyMessageResult messageResult, Optional<MimePath> path) {
        return messageResult.iterateMimeHeaders(path.get());
    }

    private FetchResponse.BodyElement content(ProxyMessageResult messageResult, String name, Optional<MimePath> path) throws IOException {
        Content full = Optional.ofNullable(this.getContent(messageResult, path)).orElseGet(EmptyContent::new);
        return new ContentBodyElement(name, full);
    }

    private Content getContent(ProxyMessageResult messageResult, Optional<MimePath> path) throws IOException {
        if (path.isEmpty()) {
            return messageResult.getFullContent();
        }
        return messageResult.getMimeBody(path.get());
    }
}

