/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;

public class FullByteContent
implements Content {
    private final List<Header> headers;
    private final byte[] body;
    private final long size;

    public FullByteContent(byte[] body, List<Header> headers) {
        this.headers = headers;
        this.body = body;
        this.size = this.computeSize();
    }

    protected long computeSize() {
        long result = this.body.length;
        result += 2L;
        for (Header header : this.headers) {
            if (header == null) continue;
            result += header.size();
            result += 2L;
        }
        return result;
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (Header header : this.headers) {
            if (header == null) continue;
            out.write((header.getName() + ": " + header.getValue() + "\r\n").getBytes(StandardCharsets.US_ASCII));
        }
        out.write("\r\n".getBytes(StandardCharsets.US_ASCII));
        out.flush();
        return new SequenceInputStream(new ByteArrayInputStream(out.toByteArray()), new ByteArrayInputStream(this.body));
    }

    public long size() {
        return this.size;
    }
}

