/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.imap.encode.fetch.ResultUtils;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;

public final class HeadersImpl
implements Headers {
    private List<Header> headers;

    public HeadersImpl(Collection<Header> headers) {
        this.headers = new ArrayList<Header>(headers);
    }

    public HeadersImpl(MimeMessage msg) throws IOException {
        this.headers = ResultUtils.createHeaders(msg);
    }

    public InputStream getInputStream() throws IOException {
        if (this.headers.isEmpty()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        byte[] linefeed = new byte[]{13, 10};
        Vector<InputStream> vector = new Vector<InputStream>(this.headers.size() * 2 + 1);
        for (Header header : this.headers) {
            vector.add(header.getInputStream());
            vector.add(new ByteArrayInputStream(linefeed));
        }
        vector.add(new ByteArrayInputStream(linefeed));
        SequenceInputStream seq = new SequenceInputStream(vector.elements());
        return seq;
    }

    public long size() {
        long size = 0L;
        for (Header header : this.headers) {
            size += header.size() + 2L;
        }
        return size == 0L ? 0L : size + 2L;
    }

    public Iterator<Header> headers() {
        return this.headers.iterator();
    }

    public String toString() {
        return "HeadersImpl [headers=" + String.valueOf(this.headers) + "]";
    }

    public int hashCode() {
        return 741 + this.headers.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HeadersImpl) {
            return this.headers.equals(((HeadersImpl)obj).headers);
        }
        return false;
    }
}

