/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.savignano.uptrust.proxy.imap.encode.fetch.FullByteContent;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;

public class PartContentBuilder {
    private static final byte[] EMPTY = new byte[0];
    private final MimeTokenStream parser = new MimeTokenStream(MimeConfig.PERMISSIVE);
    private boolean empty = false;
    private boolean topLevel = true;

    public void markEmpty() {
        this.empty = true;
    }

    public void parse(InputStream in) {
        this.parser.setRecursionMode(RecursionMode.M_RECURSE);
        this.parser.parse(in);
        this.topLevel = true;
    }

    private void skipToStartOfInner(int position) throws IOException, MimeException {
        EntityState state = this.parser.next();
        switch (state) {
            case T_START_MULTIPART: {
                break;
            }
            case T_START_MESSAGE: {
                break;
            }
            case T_END_OF_STREAM: {
                throw new PartNotFoundException(position);
            }
            case T_END_BODYPART: {
                throw new PartNotFoundException(position);
            }
            default: {
                this.skipToStartOfInner(position);
            }
        }
    }

    public void to(int position) throws IOException, MimeException {
        try {
            if (this.topLevel) {
                this.topLevel = false;
            } else {
                this.skipToStartOfInner(position);
            }
            int count = 0;
            while (count < position) {
                EntityState state = this.parser.next();
                switch (state) {
                    case T_BODY: {
                        if (position != 1) break;
                        ++count;
                        break;
                    }
                    case T_START_BODYPART: {
                        ++count;
                        break;
                    }
                    case T_START_MULTIPART: {
                        if (count <= 0 || count >= position) break;
                        this.ignoreInnerMessage();
                        break;
                    }
                    case T_END_OF_STREAM: {
                        throw new PartNotFoundException(position);
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            throw new PartNotFoundException(position, e);
        }
    }

    private void ignoreInnerMessage() throws IOException, UnexpectedEOFException, MimeException {
        EntityState state = this.parser.next();
        while (state != EntityState.T_END_MULTIPART) {
            switch (state) {
                case T_END_OF_STREAM: {
                    throw new UnexpectedEOFException();
                }
                case T_START_MULTIPART: {
                    this.ignoreInnerMessage();
                    break;
                }
            }
            state = this.parser.next();
        }
    }

    public Content getFullContent() throws IOException, UnexpectedEOFException, MimeException {
        List<Header> headers = this.getMimeHeaders();
        byte[] content = this.mimeBodyContent();
        return new FullByteContent(content, headers);
    }

    public Content getMessageBodyContent() throws IOException, MimeException {
        byte[] content = this.messageBodyContent();
        return new ByteContent(content);
    }

    private byte[] messageBodyContent() throws IOException, MimeException {
        byte[] content;
        if (this.empty) {
            content = EMPTY;
        } else {
            boolean valid;
            try {
                this.advancedToMessage();
                valid = true;
            }
            catch (UnexpectedEOFException e) {
                valid = false;
            }
            if (valid) {
                this.parser.setRecursionMode(RecursionMode.M_FLAT);
                EntityState state = this.parser.getState();
                while (state != EntityState.T_BODY && state != EntityState.T_START_MULTIPART) {
                    if (state == EntityState.T_END_OF_STREAM) {
                        valid = false;
                        break;
                    }
                    state = this.parser.next();
                }
                content = valid ? IOUtils.toByteArray((InputStream)this.parser.getInputStream()) : EMPTY;
            } else {
                content = EMPTY;
            }
        }
        return content;
    }

    public Content getMimeBodyContent() throws IOException, MimeException {
        byte[] content = this.mimeBodyContent();
        return new ByteContent(content);
    }

    private byte[] mimeBodyContent() throws IOException, MimeException {
        byte[] content;
        if (this.empty) {
            content = EMPTY;
        } else {
            this.parser.setRecursionMode(RecursionMode.M_FLAT);
            boolean valid = true;
            EntityState state = this.parser.getState();
            while (state != EntityState.T_BODY && state != EntityState.T_START_MULTIPART) {
                if (state == EntityState.T_END_OF_STREAM) {
                    valid = false;
                    break;
                }
                state = this.parser.next();
            }
            content = valid ? IOUtils.toByteArray((InputStream)this.parser.getInputStream()) : EMPTY;
        }
        return content;
    }

    public List<Header> getMimeHeaders() throws IOException, UnexpectedEOFException, MimeException {
        List<Header> results;
        if (this.empty) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList();
            EntityState state = this.parser.getState();
            while (state != EntityState.T_END_HEADER) {
                switch (state) {
                    case T_END_OF_STREAM: {
                        throw new UnexpectedEOFException();
                    }
                    case T_FIELD: {
                        String fieldValue = this.parser.getField().getBody().trim();
                        String fieldName = this.parser.getField().getName();
                        Header header = new Header(fieldName, fieldValue);
                        results.add(header);
                        break;
                    }
                }
                state = this.parser.next();
            }
        }
        return results;
    }

    public List<Header> getMessageHeaders() throws IOException, MimeException {
        List<Header> results;
        if (this.empty) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList();
            try {
                this.advancedToMessage();
                EntityState state = this.parser.getState();
                while (state != EntityState.T_END_HEADER) {
                    switch (state) {
                        case T_END_OF_STREAM: {
                            throw new IOException("Unexpected EOF");
                        }
                        case T_FIELD: {
                            String fieldValue = this.parser.getField().getBody().trim();
                            String fieldName = this.parser.getField().getName();
                            Header header = new Header(fieldName, fieldValue);
                            results.add(header);
                            break;
                        }
                    }
                    state = this.parser.next();
                }
            }
            catch (UnexpectedEOFException unexpectedEOFException) {
                // empty catch block
            }
        }
        return results;
    }

    private void advancedToMessage() throws IOException, UnexpectedEOFException, MimeException {
        EntityState state = this.parser.getState();
        while (state != EntityState.T_START_MESSAGE) {
            if (state == EntityState.T_END_OF_STREAM) {
                throw new UnexpectedEOFException();
            }
            state = this.parser.next();
        }
    }

    public static final class PartNotFoundException
    extends MimeException {
        private static final long serialVersionUID = 7519976990944851574L;
        private final int position;

        public PartNotFoundException(int position) {
            this(position, null);
        }

        public PartNotFoundException(int position, Exception e) {
            super("Part " + position + " not found.", (Throwable)e);
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static final class UnexpectedEOFException
    extends MimeException {
        private static final long serialVersionUID = -3755637466593055796L;

        public UnexpectedEOFException() {
            super("Unexpected EOF");
        }
    }
}

