/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.imap.encode.fetch.HeadersImpl;
import net.savignano.uptrust.proxy.imap.encode.fetch.MimeDescriptorImpl;
import net.savignano.uptrust.proxy.imap.encode.fetch.ResultUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mime4j.MimeException;

public class ProxyMessageResult
implements MessageResult {
    private static final String TAB = " ";
    private final MimeMessage message;
    private final MessageMetaData metaData;
    private final Map<MimePath, PartContent> partsByPath = new HashMap<MimePath, PartContent>();
    private FetchGroup fetchGroup;
    private boolean mimePathContentInitialized;
    private HeadersImpl headers;
    private MimeDescriptor mimeDescriptor;
    private Content fullContent;
    private Content bodyContent;

    public ProxyMessageResult(MimeMessage msg, MessageMetaData metaData) {
        this.message = msg;
        this.metaData = metaData != null ? metaData : new MessageMetaData(null, null, null, 0L, null, null, null);
    }

    public FetchGroup getFetchGroup() {
        return this.fetchGroup;
    }

    public void setFetchGroup(FetchGroup fetchGroup) {
        this.fetchGroup = fetchGroup;
    }

    public MessageMetaData messageMetaData() {
        return this.metaData;
    }

    public MailboxId getMailboxId() {
        return null;
    }

    public MessageUid getUid() {
        return this.metaData.getUid();
    }

    public MessageId getMessageId() {
        return this.metaData.getMessageId();
    }

    public ThreadId getThreadId() {
        return this.metaData.getThreadId();
    }

    public Date getInternalDate() {
        return this.metaData.getInternalDate();
    }

    public Flags getFlags() {
        return this.metaData.getFlags();
    }

    public ModSeq getModSeq() {
        return this.metaData.getModSeq();
    }

    public long getSize() {
        try {
            return this.getFullContent().size();
        }
        catch (IOException | MailboxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public int compareTo(MessageResult that) {
        return this.getUid().compareTo(that.getUid());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getUid()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProxyMessageResult) {
            ProxyMessageResult that = (ProxyMessageResult)obj;
            return this.metaData.equals((Object)that.metaData);
        }
        return false;
    }

    public final Content getFullContent() throws IOException {
        if (this.fullContent == null) {
            try {
                ResultUtils.loadFullContent(this.message, this);
            }
            catch (MimeException e) {
                throw new IOException("Could not get full content.", e);
            }
        }
        return this.fullContent;
    }

    final void setFullContent(Content content) {
        this.fullContent = content;
    }

    public final Content getBody() throws IOException {
        if (this.bodyContent == null) {
            try {
                ResultUtils.loadBodyContent(this.message, this);
            }
            catch (MimeException e) {
                throw new IOException("Could not get full content.", e);
            }
        }
        return this.bodyContent;
    }

    final void setBodyContent(Content content) {
        this.bodyContent = content;
    }

    public String toString() {
        return "MessageResultImpl ( uid = " + String.valueOf(this.getUid()) + " flags = " + String.valueOf(this.getFlags()) + " size = " + this.getSize() + " internalDate = " + String.valueOf(this.getInternalDate()) + ")";
    }

    public Content getBody(MimePath path) {
        this.initMimePathContent();
        PartContent partContent = this.getPartContent(path);
        return partContent.getBody();
    }

    public Content getMimeBody(MimePath path) {
        this.initMimePathContent();
        PartContent partContent = this.getPartContent(path);
        return partContent.getMimeBody();
    }

    public Content getFullContent(MimePath path) {
        this.initMimePathContent();
        PartContent partContent = this.getPartContent(path);
        return partContent.getFull();
    }

    public Iterator<Header> iterateHeaders(MimePath path) {
        this.initMimePathContent();
        PartContent partContent = this.getPartContent(path);
        return partContent.getHeaders();
    }

    public Iterator<Header> iterateMimeHeaders(MimePath path) {
        this.initMimePathContent();
        PartContent partContent = this.getPartContent(path);
        return partContent.getMimeHeaders();
    }

    void setBodyContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setBody(content);
    }

    void setMimeBodyContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeBody(content);
    }

    void setFullContent(MimePath path, Content content) {
        PartContent partContent = this.getPartContent(path);
        partContent.setFull(content);
    }

    void setHeaders(MimePath path, Iterator<Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setHeaders(headers);
    }

    void setMimeHeaders(MimePath path, Iterator<Header> headers) {
        PartContent partContent = this.getPartContent(path);
        partContent.setMimeHeaders(headers);
    }

    private void initMimePathContent() {
        if (this.mimePathContentInitialized) {
            return;
        }
        try {
            ResultUtils.loadMessageResult(this.message, this.getFetchGroup(), this);
        }
        catch (IOException | MimeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private PartContent getPartContent(MimePath path) {
        return this.partsByPath.computeIfAbsent(path, any -> new PartContent());
    }

    public MimeDescriptor getMimeDescriptor() {
        if (this.mimeDescriptor == null) {
            try {
                this.mimeDescriptor = MimeDescriptorImpl.build(this.getFullContent().getInputStream());
            }
            catch (IOException | MimeException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.mimeDescriptor;
    }

    private boolean isComposite(String mediaType) {
        return "message".equalsIgnoreCase(mediaType) || "multipart".equalsIgnoreCase(mediaType);
    }

    public HeadersImpl getHeaders() {
        if (this.headers == null) {
            try {
                this.headers = new HeadersImpl(this.message);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.headers;
    }

    public List<MessageAttachmentMetadata> getLoadedAttachments() {
        return Collections.emptyList();
    }

    private static final class PartContent {
        private Content body;
        private Content mimeBody;
        private Content full;
        private Iterator<Header> headers;
        private Iterator<Header> mimeHeaders;

        private PartContent() {
        }

        public Content getBody() {
            return this.body;
        }

        public void setBody(Content body) {
            this.body = body;
        }

        Content getMimeBody() {
            return this.mimeBody;
        }

        void setMimeBody(Content mimeBody) {
            this.mimeBody = mimeBody;
        }

        public Content getFull() {
            return this.full;
        }

        public void setFull(Content full) {
            this.full = full;
        }

        public Iterator<Header> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Iterator<Header> headers) {
            this.headers = headers;
        }

        Iterator<Header> getMimeHeaders() {
            return this.mimeHeaders;
        }

        void setMimeHeaders(Iterator<Header> mimeHeaders) {
            this.mimeHeaders = mimeHeaders;
        }
    }
}

