/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.encode.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.imap.encode.fetch.PartContentBuilder;
import net.savignano.uptrust.proxy.imap.encode.fetch.ProxyMessageResult;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.PartContentDescriptor;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class ResultUtils {
    private static final EnumSet<FetchGroup.Profile> SUPPORTED_GROUPS = EnumSet.of(FetchGroup.Profile.HEADERS, FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT, FetchGroup.Profile.MIME_DESCRIPTOR);

    public static List<Header> createHeaders(MimeMessage document) throws IOException {
        final ArrayList<Header> results = new ArrayList<Header>();
        final MimeStreamParser parser = new MimeStreamParser(MimeConfig.PERMISSIVE);
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(Field field) throws MimeException {
                String fieldValue;
                if (field instanceof RawField) {
                    int off;
                    ByteSequence raw = field.getRaw();
                    int len = raw.length();
                    if (len > (off = ((RawField)field).getDelimiterIdx() + 1) + 1 && (raw.byteAt(off) & 0xFF) == 32) {
                        ++off;
                    }
                    fieldValue = ContentUtil.decode((ByteSequence)raw, (int)off, (int)(len - off));
                } else {
                    fieldValue = field.getBody();
                }
                if (fieldValue.endsWith("\r\f")) {
                    fieldValue = fieldValue.substring(0, fieldValue.length() - 2);
                }
                if (fieldValue.startsWith(" ")) {
                    fieldValue = fieldValue.substring(1);
                }
                Header header = new Header(field.getName(), fieldValue);
                results.add(header);
            }
        });
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            document.writeTo((OutputStream)os);
        }
        catch (MessagingException e) {
            throw new IOException("Unable to write out message " + String.valueOf(document), e);
        }
        try {
            parser.parse((InputStream)new ByteArrayInputStream(os.toByteArray()));
        }
        catch (MimeException e) {
            throw new IOException("Unable to parse headers of message " + String.valueOf(document), e);
        }
        return results;
    }

    public static void loadFullContent(MimeMessage message, ProxyMessageResult result) throws IOException, MimeException {
        PartContentBuilder partContentBuilder = new PartContentBuilder();
        partContentBuilder.parse(new ByteArrayInputStream(ResultUtils.getMessageBytes(message)));
        result.setFullContent(partContentBuilder.getFullContent());
    }

    public static void loadBodyContent(MimeMessage message, ProxyMessageResult result) throws IOException, MimeException {
        PartContentBuilder partContentBuilder = new PartContentBuilder();
        partContentBuilder.parse(new ByteArrayInputStream(ResultUtils.getMessageBytes(message)));
        result.setBodyContent(partContentBuilder.getMimeBodyContent());
    }

    public static void loadMessageResult(MimeMessage message, FetchGroup fetchGroup, ProxyMessageResult result) throws IOException, MimeException {
        byte[] msgBytes = ResultUtils.getMessageBytes(message);
        ResultUtils.setContent(msgBytes, result);
        if (fetchGroup != null) {
            if (!ResultUtils.haveValidContent(fetchGroup)) {
                throw new UnsupportedOperationException("Unsupported result: " + String.valueOf(fetchGroup.profiles()));
            }
            ResultUtils.addPartContent(fetchGroup, msgBytes, result);
        }
    }

    private static byte[] getMessageBytes(MimeMessage message) throws IOException, MimeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)os);
        }
        catch (MessagingException e) {
            throw new MimeException("Could not write mime message.", (Throwable)e);
        }
        return os.toByteArray();
    }

    private static boolean haveValidContent(FetchGroup fetchGroup) {
        return fetchGroup.profiles().stream().allMatch(SUPPORTED_GROUPS::contains);
    }

    private static void setContent(byte[] message, ProxyMessageResult messageResult) throws IOException, MimeException {
        PartContentBuilder partContentBuilder = new PartContentBuilder();
        partContentBuilder.parse(new ByteArrayInputStream(message));
        messageResult.setFullContent(partContentBuilder.getFullContent());
    }

    private static void addPartContent(FetchGroup fetchGroup, byte[] message, ProxyMessageResult messageResult) throws IOException, MimeException {
        Set partContent = fetchGroup.getPartContentDescriptors();
        if (partContent != null) {
            for (PartContentDescriptor descriptor : partContent) {
                ResultUtils.addPartContent(descriptor, message, messageResult);
            }
        }
    }

    private static void addPartContent(PartContentDescriptor descriptor, byte[] message, ProxyMessageResult messageResult) throws IOException, MimeException {
        MimePath mimePath = descriptor.path();
        EnumSet profiles = descriptor.profiles();
        if (profiles.contains(FetchGroup.Profile.FULL_CONTENT)) {
            ResultUtils.addFullContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.BODY_CONTENT)) {
            ResultUtils.addBodyContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.MIME_CONTENT)) {
            ResultUtils.addMimeBodyContent(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.HEADERS)) {
            ResultUtils.addHeaders(message, messageResult, mimePath);
        }
        if (profiles.contains(FetchGroup.Profile.MIME_HEADERS)) {
            ResultUtils.addMimeHeaders(message, messageResult, mimePath);
        }
    }

    private static PartContentBuilder build(int[] path, byte[] message) throws IOException, MimeException {
        ByteArrayInputStream stream = new ByteArrayInputStream(message);
        PartContentBuilder result = new PartContentBuilder();
        result.parse(stream);
        try {
            for (int next : path) {
                result.to(next);
            }
        }
        catch (PartContentBuilder.PartNotFoundException e) {
            result.markEmpty();
        }
        return result;
    }

    private static int[] path(MimePath mimePath) {
        if (mimePath == null) {
            return null;
        }
        return mimePath.getPositions();
    }

    private static void addHeaders(byte[] message, ProxyMessageResult messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            List<Header> headers = builder.getMessageHeaders();
            messageResult.setHeaders(mimePath, headers.iterator());
        }
    }

    private static void addMimeHeaders(byte[] message, ProxyMessageResult messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            List<Header> headers = builder.getMimeHeaders();
            messageResult.setMimeHeaders(mimePath, headers.iterator());
        }
    }

    private static void addBodyContent(byte[] message, ProxyMessageResult messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            Content content = builder.getMessageBodyContent();
            messageResult.setBodyContent(mimePath, content);
        }
    }

    private static void addMimeBodyContent(byte[] message, ProxyMessageResult messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            Content content = builder.getMimeBodyContent();
            messageResult.setMimeBodyContent(mimePath, content);
        }
    }

    private static void addFullContent(byte[] message, ProxyMessageResult messageResult, MimePath mimePath) throws IOException, MimeException {
        int[] path = ResultUtils.path(mimePath);
        if (path != null) {
            PartContentBuilder builder = ResultUtils.build(path, message);
            Content content = builder.getFullContent();
            messageResult.setFullContent(mimePath, content);
        }
    }
}

