/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor;

import java.io.IOException;
import net.savignano.uptrust.proxy.imap.processor.ProxyProcessor;
import net.savignano.uptrust.proxy.imap.request.CapabilityProxyRequest;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.slf4j.Logger;

public class CapabilityProxyProcessor
extends ProxyProcessor<CapabilityProxyRequest> {
    private static final String CAPABILITY_RESPONSE = "* " + ImapConstants.CAPABILITY_COMMAND.getName() + " ";
    private static final String START_TLS_CAPABILITY = " " + ImapConstants.SUPPORTS_STARTTLS.asString();
    private static final String LOGIN_DISABLED_CAPABILITY = " LOGINDISABLED";
    private static final Capability LITERAL_PLUS_CAPABILITY = ImapConstants.SUPPORTS_LITERAL_PLUS;
    private static final Capability LITERAL_MINUS_CAPABILITY = Capability.of((String)"LITERAL-");

    public static final String adjustCapabilities(String capabilities, ImapSession session, Logger log) {
        return CapabilityProxyProcessor.handleLine(capabilities, session, log != null ? log : LOGGER);
    }

    private static final void handleLines(String[] lines, ImapSession session, Logger log) {
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!CapabilityProxyProcessor.isCapabilityLine(line)) continue;
            lines[i] = CapabilityProxyProcessor.handleLine(line, session, log);
        }
    }

    private static final boolean isCapabilityLine(String line) {
        return StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)CAPABILITY_RESPONSE);
    }

    private static final String handleLine(String line, ImapSession session, Logger log) {
        String newCapa = line;
        newCapa = CapabilityProxyProcessor.handleStartTls(newCapa, session.supportStartTLS() && !session.isTLSActive(), session.enforceStartTLS(), log);
        return CapabilityProxyProcessor.handleLiteral(newCapa, session, log);
    }

    private static final String handleStartTls(String line, boolean support, boolean enforce, Logger log) {
        if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)START_TLS_CAPABILITY)) {
            return CapabilityProxyProcessor.serverAdvertisesStartTls(line, support, enforce, log);
        }
        return CapabilityProxyProcessor.serverDoesNotAdvertisesStartTls(line, support, enforce, log);
    }

    private static final String serverAdvertisesStartTls(String line, boolean support, boolean enforce, Logger log) {
        boolean serverEnforced = StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)LOGIN_DISABLED_CAPABILITY);
        if (serverEnforced) {
            log.warn("Found \"LOGINDISABLED\" capability while server is also advertising \"STARTTLS\" capability, so the server is expecting a \"STARTTLS\" command before allowing login/authentication to happen. This will probably prevent the client from log into the server, as the connection between client -> Uptrust and Uptrust -> server are separately handled. To fix this, change the configuration of the email server from \"tls=disabled\" to \"tls=starttls\".");
        }
        if (enforce && !serverEnforced) {
            log.debug("Adding \"LOGINDISABLED\" capability.");
            return line + LOGIN_DISABLED_CAPABILITY;
        }
        if (!support) {
            log.debug("Removing \"STARTTLS\" capability.");
            if (serverEnforced) {
                log.debug("Removing \"LOGINDISABLED\" capability.");
                return line.replace(LOGIN_DISABLED_CAPABILITY, "").replace(START_TLS_CAPABILITY, "");
            }
            return line.replace(START_TLS_CAPABILITY, "");
        }
        if (!enforce && serverEnforced) {
            return line.replace(LOGIN_DISABLED_CAPABILITY, "");
        }
        return line;
    }

    private static final String serverDoesNotAdvertisesStartTls(String line, boolean support, boolean enforce, Logger log) {
        if (support) {
            log.debug("Adding \"STARTTLS\" capability.");
            if (enforce) {
                log.debug("Adding \"LOGINDISABLED\" capability.");
                return line + START_TLS_CAPABILITY + LOGIN_DISABLED_CAPABILITY;
            }
            return line + START_TLS_CAPABILITY;
        }
        return line;
    }

    private static final String handleLiteral(String line, ImapSession session, Logger log) {
        if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)LITERAL_PLUS_CAPABILITY.asString())) {
            log.debug("Detected LITERAL+ capability.");
            session.setAttribute("capability.literal", (Object)LITERAL_PLUS_CAPABILITY);
        } else if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)LITERAL_MINUS_CAPABILITY.asString())) {
            log.debug("Detected LITERAL- capability.");
            session.setAttribute("capability.literal", (Object)LITERAL_MINUS_CAPABILITY);
        } else {
            log.debug("No LITERAL capability detected.");
        }
        return line;
    }

    public CapabilityProxyProcessor(StatusResponseFactory factory, ImapProcessor next) {
        super(CapabilityProxyRequest.class, factory, next);
        this.setIgnoreEnforceStartTls(true);
    }

    @Override
    protected void doProcess(ProxyProcessor.ProxyData<CapabilityProxyRequest> data) throws IOException {
        super.doProcess(data);
        ImapResponseMessage imapResponseMessage = data.response;
        if (imapResponseMessage instanceof ProxyResponse) {
            ProxyResponse response = (ProxyResponse)imapResponseMessage;
            CapabilityProxyProcessor.handleLines(response.getLines(), data.session, this.log);
        }
    }
}

