/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.savignano.cryptography.Constants;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.imap.processor.ProxyProcessor;
import net.savignano.uptrust.proxy.imap.request.IdleProxyRequest;
import net.savignano.uptrust.proxy.imap.request.IdlingProxyRequest;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.concurrent.NamedThreadFactory;

public class IdleProxyProcessor
extends ProxyProcessor<IdleProxyRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_IDLE);
    private final ScheduledExecutorService idleExecutor;
    private TimeUnit pollIntervalUnit = TimeUnit.SECONDS;
    private long pollInterval = 1L;
    private boolean enableHeartbeat;
    private TimeUnit heartbeatIntervalUnit;
    private long heartbeatInterval;

    public IdleProxyProcessor(StatusResponseFactory factory, ImapProcessor next) {
        super(IdleProxyRequest.class, factory, next);
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(((Object)((Object)this)).getClass());
        this.idleExecutor = Executors.newScheduledThreadPool(5, (ThreadFactory)threadFactory);
    }

    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.heartbeatInterval = imapConfiguration.getIdleTimeInterval();
        this.heartbeatIntervalUnit = imapConfiguration.getIdleTimeIntervalUnit();
        this.enableHeartbeat = imapConfiguration.isEnableIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcess(ProxyProcessor.ProxyData<IdleProxyRequest> data) throws IOException {
        IProxy<ProxyRequest, ProxyResponse> iProxy = data.proxy;
        synchronized (iProxy) {
            if (data.request instanceof IdlingProxyRequest) {
                this.processIdling(data);
            } else {
                this.processIdle(data);
            }
        }
    }

    private void processIdling(ProxyProcessor.ProxyData<IdleProxyRequest> data) throws IOException {
        super.doProcess(data);
    }

    private void processIdle(ProxyProcessor.ProxyData<IdleProxyRequest> data) throws IOException {
        super.doProcess(data);
        if (this.isContinuationResponse(data.response)) {
            this.startIdling(data);
        }
    }

    private void startIdling(ProxyProcessor.ProxyData<IdleProxyRequest> data) {
        AtomicBoolean idleActive = new AtomicBoolean(true);
        this.listenOnServer(idleActive, data);
        data.session.pushLineHandler(this.enableIdleCompletion(idleActive, data));
        if (this.enableHeartbeat) {
            this.enableHeartbeat(idleActive, data);
        }
    }

    private ImapLineHandler enableIdleCompletion(AtomicBoolean idleActive, ProxyProcessor.ProxyData<IdleProxyRequest> data) {
        return (session, dataBytes) -> {
            this.log.debug("Ending idle thread for: {}", (Object)data.proxy.getAddress());
            idleActive.set(false);
            session.popLineHandler();
            String line = new String(dataBytes, Constants.ASCII_CHARSET);
            IdleProxyRequest pr = new IdleProxyRequest(((IdleProxyRequest)((Object)((Object)data.request))).getTag(), line);
            pr.setLiteralData(true);
            this.doProcess(pr, data.responder, session);
        };
    }

    private void listenOnServer(final AtomicBoolean idleActive, final ProxyProcessor.ProxyData<IdleProxyRequest> data) {
        this.log.debug("Starting idle thread for: {}", (Object)data.proxy.getAddress());
        this.idleExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (data.session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                    IdleProxyProcessor.this.log.trace("Idling...");
                    IdlingProxyRequest idling = new IdlingProxyRequest();
                    IdleProxyProcessor.this.doProcess(idling, data.responder, data.session);
                    IdleProxyProcessor.this.idleExecutor.schedule(this, IdleProxyProcessor.this.getPollInterval(), IdleProxyProcessor.this.getPollIntervalUnit());
                }
            }
        }, this.getPollInterval(), this.getPollIntervalUnit());
    }

    private void enableHeartbeat(final AtomicBoolean idleActive, final ProxyProcessor.ProxyData<IdleProxyRequest> data) {
        this.log.debug("Starting hearbeat thread for client of connection to: {}", (Object)data.proxy.getAddress());
        this.idleExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                if (data.session.getState() != ImapSessionState.LOGOUT && idleActive.get()) {
                    IdleProxyProcessor.this.log.trace("Heartbeat...");
                    StatusResponse response = IdleProxyProcessor.this.getFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                    data.responder.respond((ImapResponseMessage)response);
                    IdleProxyProcessor.this.idleExecutor.schedule(this, IdleProxyProcessor.this.heartbeatInterval, IdleProxyProcessor.this.heartbeatIntervalUnit);
                }
            }
        }, this.heartbeatInterval, this.heartbeatIntervalUnit);
    }

    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(IdleProxyRequest message) {
        return MDCBuilder.create().addToContext("action", "IDLE").build();
    }

    public TimeUnit getPollIntervalUnit() {
        return this.pollIntervalUnit;
    }

    public void setPollIntervalUnit(TimeUnit pollIntervalUnit) {
        this.pollIntervalUnit = pollIntervalUnit;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }
}

