/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.response.BaseProxyResponse;
import net.savignano.uptrust.proxy.imap.proxy.ImapProxy;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyProcessor<R extends ProxyRequest>
extends AbstractChainedProcessor<R> {
    public static final String LITERAL_CAPABILITY_PARAM = "capability.literal";
    private static final HumanReadableText SEND_FAILURE_TEXT = HumanReadableText.SOCKET_IO_FAILURE;
    private static final HumanReadableText NOT_CONNECTED_TEXT = new HumanReadableText("net.savignano.uptrust.imap.NOT_CONNECTED", "failed. Not connected to email server.");
    private static final HumanReadableText ENFORCE_STARTTLS_TEXT = new HumanReadableText("net.savignano.uptrust.imap.ENFORCE_STARTTLS", "[PRIVACYREQUIRED] Please use STARTTLS command first.");
    private static final HumanReadableText MISSING_RESPONSE_TEXT = HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final StatusResponseFactory factory;
    private boolean ignoreEnforceStartTls;

    public ProxyProcessor(Class<R> acceptableClass, StatusResponseFactory factory, ImapProcessor next) {
        super(acceptableClass, next);
        this.factory = factory;
    }

    protected void doProcess(R request, ImapProcessor.Responder responder, ImapSession session) {
        this.log.debug("Proxy request: {}", request);
        ProxyData<R> data = this.createProxyData(request, responder, session);
        this.process(data);
    }

    private ProxyData<R> createProxyData(R request, ImapProcessor.Responder responder, ImapSession session) {
        ProxyData data = new ProxyData();
        data.request = request;
        data.responder = responder;
        data.session = session;
        data.proxy = this.getProxy(session);
        return data;
    }

    private void process(ProxyData<R> data) {
        if (data.proxy == null || !data.proxy.isReady()) {
            this.log.error("Not conntected to remote server at \"{}\".", this.getProxyAddress(data.proxy));
            data.response = this.getProxyConnectionFailure((ProxyRequest)((Object)data.request));
            data.session.logout();
        }
        if (data.session.supportStartTLS() && !data.session.isTLSActive() && data.session.enforceStartTLS() && !this.isIgnoreEnforceStartTls()) {
            this.log.debug("Start TLS not yet activated, but is enforced by session configuration.");
            data.response = this.getEnforcedStartTlsFailure((ProxyRequest)((Object)data.request));
        }
        if (data.response == null) {
            try {
                this.doProcess(data);
                this.log.debug("Proxy response: {}", (Object)data.response);
            }
            catch (IOException e) {
                this.log.error("Error communicating with server at \"" + String.valueOf(this.getProxyAddress(data.proxy)) + "\". Error message: " + e.getMessage(), (Throwable)e);
                data.response = this.getSendFailure((ProxyRequest)((Object)data.request));
                data.session.logout();
            }
        }
        if (data.response == null) {
            this.log.debug("Processor {} returned null response. Creating default failure response.", (Object)((Object)((Object)this)).getClass().getSimpleName());
            data.response = this.getMissingResponseFailure((ProxyRequest)((Object)data.request));
        }
        data.responder.respond(data.response);
        if (this.isLogoutResponse(data.response)) {
            data.session.logout();
        } else {
            Optional<ImapLineHandler> followupHandler = this.getClientFollowupHandler(data);
            if (followupHandler.isPresent()) {
                data.session.pushLineHandler(followupHandler.get());
            }
        }
    }

    protected void doProcess(ProxyData<R> data) throws IOException {
        data.response = (ImapResponseMessage)data.proxy.send(data.request);
    }

    protected Optional<ImapLineHandler> getClientFollowupHandler(ProxyData<R> data) {
        return Optional.empty();
    }

    private boolean isLogoutResponse(ImapResponseMessage response) {
        if (!(response instanceof BaseProxyResponse)) {
            return false;
        }
        for (String line : ((BaseProxyResponse)response).getLines()) {
            if (line.length() < 5 || !line.substring(0, 5).equalsIgnoreCase("* bye")) continue;
            return true;
        }
        return false;
    }

    private ImapResponseMessage getProxyConnectionFailure(ProxyRequest request) {
        Tag tag = request.getTag();
        ImapCommand command = request.getCommand();
        return this.getFactory().taggedBad(tag, command, NOT_CONNECTED_TEXT);
    }

    private ImapResponseMessage getSendFailure(ProxyRequest request) {
        Tag tag = request.getTag();
        ImapCommand command = request.getCommand();
        return this.getFactory().taggedBad(tag, command, SEND_FAILURE_TEXT);
    }

    private ImapResponseMessage getMissingResponseFailure(ProxyRequest request) {
        Tag tag = request.getTag();
        ImapCommand command = request.getCommand();
        return this.getFactory().taggedBad(tag, command, MISSING_RESPONSE_TEXT);
    }

    private ImapResponseMessage getEnforcedStartTlsFailure(ProxyRequest request) {
        Tag tag = request.getTag();
        ImapCommand command = request.getCommand();
        return this.getFactory().taggedNo(tag, command, ENFORCE_STARTTLS_TEXT);
    }

    private IProxy<ProxyRequest, ProxyResponse> getProxy(ImapSession session) {
        return (IProxy)session.getAttribute(ImapProxy.PROXY_PARAM);
    }

    protected boolean isContinuationResponse(ImapResponseMessage response) {
        if (!(response instanceof ProxyResponse)) {
            return false;
        }
        String[] lines = ((ProxyResponse)response).getLines();
        if (lines.length == 0) {
            return false;
        }
        String lastLine = lines[lines.length - 1];
        return lastLine.startsWith("+");
    }

    protected Closeable addContextToMDC(R message) {
        return MDCBuilder.create().addToContext("action", "PROXY").build();
    }

    protected StatusResponseFactory getFactory() {
        return this.factory;
    }

    private Object getProxyAddress(IProxy<?, ?> proxy) {
        return proxy == null ? "N/A" : proxy.getAddress();
    }

    protected boolean isIgnoreEnforceStartTls() {
        return this.ignoreEnforceStartTls;
    }

    protected void setIgnoreEnforceStartTls(boolean ignoreEnforceStartTls) {
        this.ignoreEnforceStartTls = ignoreEnforceStartTls;
    }

    public static class ProxyData<T extends ProxyRequest> {
        public IProxy<ProxyRequest, ProxyResponse> proxy;
        public T request;
        public ImapResponseMessage response;
        public ImapProcessor.Responder responder;
        public ImapSession session;
    }
}

