/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor.append;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.uptrust.proxy.base.handler.IMailHandler;
import net.savignano.uptrust.proxy.imap.processor.append.AppendMailHandlerConfiguration;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.config.CryptographyServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendMailHandler
implements IMailHandler {
    public static final String RELEVANT_ADDRESSES_CONTEXT_KEY = "relevantAddresses";
    private static final Logger LOG = LoggerFactory.getLogger(AppendMailHandler.class);
    private static final String ENCRYPTION_ERROR_HEADER = "X-EncryptionError";
    private static final String SIGNING_ERROR_HEADER = "X-SigningError";
    private final AppendMailHandlerConfiguration config;

    public AppendMailHandler(AppendMailHandlerConfiguration config) {
        this.config = config;
        if (config == null) {
            throw new NullPointerException("Configuration must not be null.");
        }
    }

    public void handleMessage(MimeMessage msg, Map<String, Object> context) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        LOG.debug("Handling appending message with ID \"{}\".", (Object)msgId);
        LOG.trace("Context for message handling: {}", context);
        if (!this.config.getLicenseService().isValid()) {
            LOG.error("No valid license configured. Message with ID \"{}\" will not be cryptographically processed.", (Object)msgId);
            return;
        }
        Function<MimeMessage, ECryptographyType> detectCryptoFunc = this.config.getDetectCryptoFunc();
        if (detectCryptoFunc == null) {
            LOG.error("Can not determine cryptography of message. Uptrust not correctly configured. Cannot protect message.");
            return;
        }
        ECryptographyType cryptography = detectCryptoFunc.apply(msg);
        if (cryptography != ECryptographyType.NONE) {
            if (this.config.getEncryptedPred().test(msg)) {
                LOG.info("Message with ID \"{}\" already protected.");
            } else {
                LOG.info("Message with ID \"{}\" needs additional encryption.");
                IEncryptionService.EncryptionResult encnResult = this.encrypt(msg, cryptography, (Collection)context.get(RELEVANT_ADDRESSES_CONTEXT_KEY));
                LOG.debug("Result of encrypting message with ID \"{}\": {}", (Object)msgId, (Object)encnResult);
            }
        } else {
            CryptographyServiceConfiguration.ECryptographyUsage cryptoUsage = this.config.getCryptographicUsage();
            LOG.info("Protecting message with ID \"{}\" with: {}", (Object)msgId, (Object)cryptoUsage);
            switch (cryptoUsage) {
                case PGP_ONLY: 
                case SMIME_ONLY: {
                    this.handleMsg(msg, cryptoUsage.getCryptography(), context);
                    break;
                }
                case PGP_PREFERRED: 
                case SMIME_PREFERRED: {
                    Function<MimeMessage, Integer> preferred = m -> this.handleMsg((MimeMessage)m, cryptoUsage.getCryptography(), context);
                    Function<MimeMessage, Integer> fallback = m -> this.handleMsg((MimeMessage)m, cryptoUsage.getFallbackCryptography(), context);
                    this.handleWithFallback(msg, preferred, fallback);
                    break;
                }
                default: {
                    LOG.error("Unknown cryptographic usage encountered. Using default SMIME_PREFERRED to continue. Encountered usage: {}", (Object)cryptoUsage);
                    this.handleWithFallback(msg, m -> this.handleMsg((MimeMessage)m, ECryptographyType.SMIME, context), m -> this.handleMsg((MimeMessage)m, ECryptographyType.PGP, context));
                }
            }
        }
        if (!msgId.equals(MessageUtil.getMessageId((Message)msg))) {
            try {
                msg.setHeader("Message-ID", msgId);
            }
            catch (MessagingException e) {
                LOG.error("Could not reset message ID for message with sequence number: " + msg.getMessageNumber(), (Throwable)e);
            }
        }
    }

    private int handleMsg(MimeMessage msg, ECryptographyType cryptography, Map<String, Object> context) {
        int countSuccess = 0;
        String msgId = MessageUtil.getMessageId((Message)msg);
        ISigningService.SigningResult signResult = this.sign(msg, cryptography);
        LOG.debug("Result of signing message with ID \"{}\": {}", (Object)msgId, (Object)signResult);
        countSuccess += signResult.isSuccess() ? 1 : 0;
        IEncryptionService.EncryptionResult encnResult = this.encrypt(msg, cryptography, (Collection)context.get(RELEVANT_ADDRESSES_CONTEXT_KEY));
        LOG.debug("Result of encrypting message with ID \"{}\": {}", (Object)msgId, (Object)encnResult);
        return countSuccess += encnResult.isSuccess() ? 1 : 0;
    }

    private IEncryptionService.EncryptionResult encrypt(MimeMessage msg, ECryptographyType cryptography, Collection<Address> addresses) {
        if (this.config.getEncryptionService() == null) {
            IEncryptionService.EncryptionResult result = new IEncryptionService.EncryptionResult();
            result.setMessage(msg);
            return result;
        }
        MimeMessage safetyCopy = this.copy(msg);
        String msgId = MessageUtil.getMessageId((Message)msg);
        IEncryptionService.EncryptionResult result = this.config.getEncryptionService().encrypt(msg, cryptography, addresses);
        LOG.debug("Encryption result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        if (result.isSuccess()) {
            if (result.getMessage() != msg) {
                this.overwrite(result.getMessage(), msg);
            }
        } else if (result.getException() != null) {
            this.overwrite(safetyCopy, msg);
            try {
                MessageUtil.setHeader((Message)msg, (String)ENCRYPTION_ERROR_HEADER, (String)"Could not encrypt message. Error message: {0}", (Object[])new Object[]{result.getException().getMessage()});
            }
            catch (MessagingException e) {
                LOG.error("Could not set encryption error header in message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private ISigningService.SigningResult sign(MimeMessage msg, ECryptographyType cryptography) {
        if (this.config.getSigningService() == null) {
            ISigningService.SigningResult result = new ISigningService.SigningResult();
            result.setMessage(msg);
            return result;
        }
        MimeMessage safetyCopy = this.copy(msg);
        String msgId = MessageUtil.getMessageId((Message)msg);
        ISigningService.SigningResult result = this.config.getSigningService().sign(msg, cryptography);
        LOG.debug("Signing result for message with ID \"{}\": {}", (Object)msgId, (Object)result);
        if (result.isSuccess()) {
            if (result.getMessage() != msg) {
                this.overwrite(result.getMessage(), msg);
            }
        } else if (result.getException() != null) {
            this.overwrite(safetyCopy, msg);
            try {
                MessageUtil.setHeader((Message)msg, (String)SIGNING_ERROR_HEADER, (String)"Could not sign message. Error message: {0}", (Object[])new Object[]{result.getException().getMessage()});
            }
            catch (MessagingException e) {
                LOG.error("Could not set signing error header in message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void handleWithFallback(MimeMessage msg, Function<MimeMessage, Integer> preferred, Function<MimeMessage, Integer> fallback) {
        MimeMessage fallbackMsg;
        try {
            fallbackMsg = MessageUtil.copyMsg((MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.warn("Could not create copy of message with ID \"" + MessageUtil.getMessageId((Message)msg) + ". Cannot try fallback option. Error message: " + e.getMessage(), (Throwable)e);
            preferred.apply(msg);
            return;
        }
        int preferredSuccess = preferred.apply(msg);
        if (preferredSuccess == 2) {
            return;
        }
        int fallbackSuccess = fallback.apply(fallbackMsg);
        if (preferredSuccess >= fallbackSuccess) {
            return;
        }
        try {
            MessageUtil.overwriteMsg((MimeMessage)fallbackMsg, (MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.error("Failure to use non-preferred protection even though it succeeded, because original message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\" could not be overwritten. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private MimeMessage copy(MimeMessage msg) {
        try {
            return MessageUtil.copyMsg((MimeMessage)msg);
        }
        catch (Exception e) {
            LOG.error("Could not create safety copy of message with ID: " + MessageUtil.getMessageId((Message)msg), (Throwable)e);
            return null;
        }
    }

    private void overwrite(MimeMessage source, MimeMessage destination) {
        try {
            MessageUtil.overwriteMsg((MimeMessage)source, (MimeMessage)destination);
        }
        catch (Exception e) {
            LOG.error("Could not overwrite message with ID: " + MessageUtil.getMessageId((Message)destination), (Throwable)e);
        }
    }
}

