/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor.append;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.proxy.imap.processor.append.AppendMailHandler;
import net.savignano.uptrust.proxy.imap.processor.append.AppendMailHandlerConfiguration;
import net.savignano.uptrust.service.config.converter.EnumConverter;
import net.savignano.uptrust.service.cryptography.IEncryptionService;
import net.savignano.uptrust.service.cryptography.ISigningService;
import net.savignano.uptrust.service.cryptography.config.CryptographyServiceConfiguration;
import net.savignano.uptrust.service.license.ILicenseService;
import org.apache.commons.configuration2.ImmutableConfiguration;

public class AppendMailHandlerBuilder {
    private static final String CRYPTOGRPAHIC_USAGE_KEY = "protection";
    private final AppendMailHandlerConfiguration config = new AppendMailHandlerConfiguration();

    public static AppendMailHandlerBuilder empty() {
        return new AppendMailHandlerBuilder().cryptographicUsage(CryptographyServiceConfiguration.ECryptographyUsage.SMIME_PREFERRED);
    }

    public static AppendMailHandlerBuilder from(ImmutableConfiguration config) {
        CryptographyServiceConfiguration.ECryptographyUsage cryptoUsage = (CryptographyServiceConfiguration.ECryptographyUsage)((EnumConverter)new EnumConverter(CryptographyServiceConfiguration.ECryptographyUsage.class).from(config, CRYPTOGRPAHIC_USAGE_KEY)).get((Object)CryptographyServiceConfiguration.ECryptographyUsage.SMIME_PREFERRED);
        return AppendMailHandlerBuilder.empty().cryptographicUsage(cryptoUsage);
    }

    private AppendMailHandlerBuilder() {
    }

    public AppendMailHandler build() {
        return new AppendMailHandler(new AppendMailHandlerConfiguration(this.config));
    }

    public AppendMailHandlerBuilder cryptographicUsage(CryptographyServiceConfiguration.ECryptographyUsage usage) {
        this.config.setCryptographicUsage(usage);
        return this;
    }

    public AppendMailHandlerBuilder checkLicenseWith(ILicenseService service) {
        this.config.setLicenseService(service);
        return this;
    }

    public AppendMailHandlerBuilder encryptWith(IEncryptionService service) {
        this.config.setEncryptionService(service);
        return this;
    }

    public AppendMailHandlerBuilder signWith(ISigningService service) {
        this.config.setSigningService(service);
        return this;
    }

    public AppendMailHandlerBuilder detectCrypto(Function<MimeMessage, ECryptographyType> function) {
        this.config.setDetectCryptoFunc(function);
        return this;
    }

    public AppendMailHandlerBuilder detectEncryption(Predicate<MimeMessage> predicate) {
        this.config.setEncryptedPred(predicate);
        return this;
    }
}

