/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor.append;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.Constants;
import net.savignano.uptrust.proxy.base.handler.IMailHandler;
import net.savignano.uptrust.proxy.base.handler.UnchangedMailHandler;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.base.response.BaseProxyResponse;
import net.savignano.uptrust.proxy.imap.processor.ProxyProcessor;
import net.savignano.uptrust.proxy.imap.request.AppendFollowupProxyRequest;
import net.savignano.uptrust.proxy.imap.request.AppendProxyRequest;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;

public class AppendProxyProcessor
extends ProxyProcessor<AppendProxyRequest> {
    private static final Capability LITERAL_MINUS_CAPA = Capability.of((String)"LITERAL-");
    private static final Pattern SIZE_PATTERN = Pattern.compile("\\{(\\d+)\\+?\\}");
    private static final Pattern LITERAL_MINUS_SIZE_PATTERN = Pattern.compile("\\{(\\d+\\+?)\\}");
    private static final String APPEND_REQUEST_KEY = "appendRequest";
    private static final String APPEND_PAYLOAD_KEY = "appendPayload";
    private final Session mailSession;
    private final IMailHandler mailHandler;

    public AppendProxyProcessor(Session session, IMailHandler mailHandler, StatusResponseFactory factory, ImapProcessor next) {
        super(AppendProxyRequest.class, factory, next);
        this.mailSession = session;
        this.mailHandler = mailHandler != null ? mailHandler : new UnchangedMailHandler(this.log);
    }

    @Override
    protected void doProcess(ProxyProcessor.ProxyData<AppendProxyRequest> data) throws IOException {
        data.response = new ProxyResponse(BaseProxyResponse.NO_RESPONSE);
        if (!this.isPayload(data)) {
            data.session.setAttribute(APPEND_REQUEST_KEY, data.request);
            data.session.setAttribute(APPEND_PAYLOAD_KEY, (Object)new StringBuilder(((AppendProxyRequest)((Object)data.request)).getRemainingData()));
            if (this.needsContinuationResponse(data)) {
                data.response = new ProxyResponse("+ Continue");
            }
            return;
        }
        StringBuilder builder = (StringBuilder)data.session.getAttribute(APPEND_PAYLOAD_KEY);
        builder.append(((AppendProxyRequest)((Object)data.request)).getTransferData());
        if (!this.needsFollowup(data)) {
            try {
                this.sendMessage(data);
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void sendMessage(ProxyProcessor.ProxyData<AppendProxyRequest> data) throws MessagingException, IOException {
        AppendProxyRequest orgRequest = (AppendProxyRequest)((Object)data.session.getAttribute(APPEND_REQUEST_KEY));
        StringBuilder payload = (StringBuilder)data.session.getAttribute(APPEND_PAYLOAD_KEY);
        data.session.setAttribute(APPEND_REQUEST_KEY, null);
        data.session.setAttribute(APPEND_PAYLOAD_KEY, null);
        payload.setLength(orgRequest.getRemainingData());
        MimeMessage msg = new MimeMessage(this.mailSession, (InputStream)new ByteArrayInputStream(payload.toString().getBytes(Constants.ASCII_CHARSET)));
        this.mailHandler.handleMessage(msg);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)os);
        int newSize = os.size();
        orgRequest.setRemainingData(newSize);
        boolean isLiteralMinusCapa = LITERAL_MINUS_CAPA.equals(data.session.getAttribute("capability.literal"));
        AppendProxyRequest appendRequest = this.createAdjustedRequest(orgRequest, newSize, isLiteralMinusCapa);
        data.response = this.sendData(data.proxy, appendRequest, os);
    }

    private AppendProxyRequest createAdjustedRequest(AppendProxyRequest orgRequest, int newSize, boolean literalMinus) throws IOException {
        Object reqData;
        boolean needsSynched = literalMinus && newSize > 4096;
        Pattern usedSizePattern = needsSynched ? LITERAL_MINUS_SIZE_PATTERN : SIZE_PATTERN;
        Matcher matcher = usedSizePattern.matcher((CharSequence)(reqData = orgRequest.getData()));
        if (!matcher.find()) {
            throw new IOException("Could not parse size information from request: " + String.valueOf((Object)orgRequest));
        }
        reqData = ((String)reqData).substring(0, matcher.start(1)) + newSize + ((String)reqData).substring(matcher.end(1));
        AppendProxyRequest appendRequest = new AppendProxyRequest(orgRequest.getTag(), (String)reqData);
        appendRequest.setRemainingData(newSize);
        appendRequest.setSynched(needsSynched || orgRequest.isSynched());
        appendRequest.setExpectingServerData(needsSynched || orgRequest.isSynched());
        return appendRequest;
    }

    private ProxyResponse sendData(IProxy<ProxyRequest, ProxyResponse> proxy, AppendProxyRequest appendRequest, ByteArrayOutputStream os) throws IOException {
        ProxyResponse response = (ProxyResponse)proxy.send((IProxyRequest)appendRequest);
        if (appendRequest.isExpectingServerData() && (response.getLines().length != 1 || !response.getLines()[0].startsWith("+"))) {
            return response;
        }
        os.write("\r\n".getBytes(Constants.ASCII_CHARSET));
        ProxyRequest dataRequest = new ProxyRequest(appendRequest.getTag(), os.toString(Constants.ASCII_CHARSET));
        return (ProxyResponse)proxy.send((IProxyRequest)dataRequest);
    }

    @Override
    protected Optional<ImapLineHandler> getClientFollowupHandler(ProxyProcessor.ProxyData<AppendProxyRequest> data) {
        if (!this.needsFollowup(data)) {
            return Optional.empty();
        }
        return Optional.of((session, dataBytes) -> {
            session.popLineHandler();
            String theData = new String(dataBytes, Constants.ASCII_CHARSET);
            AppendFollowupProxyRequest followupRequest = new AppendFollowupProxyRequest((AppendProxyRequest)((Object)((Object)data.request)), theData);
            this.doProcess(followupRequest, data.responder, session);
        });
    }

    private boolean isPayload(ProxyProcessor.ProxyData<AppendProxyRequest> data) {
        return ((AppendProxyRequest)((Object)data.request)).isLiteralData();
    }

    private boolean needsContinuationResponse(ProxyProcessor.ProxyData<AppendProxyRequest> data) {
        return ((AppendProxyRequest)((Object)data.request)).isSynched();
    }

    private boolean needsFollowup(ProxyProcessor.ProxyData<AppendProxyRequest> data) {
        return ((AppendProxyRequest)((Object)data.request)).getRemainingData() >= 0;
    }
}

