/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor.fetch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.uptrust.proxy.base.handler.IMailHandler;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.imap.processor.ProxyProcessor;
import net.savignano.uptrust.proxy.imap.processor.fetch.MetaDataParser;
import net.savignano.uptrust.proxy.imap.request.FetchProxyRequest;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import net.savignano.uptrust.proxy.imap.response.FetchProxyResponse;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.model.MessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProxyProcessor
extends ProxyProcessor<FetchProxyRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(FetchProxyProcessor.class);
    private static final String SESSION_OK_ID = FetchProxyProcessor.class.getName() + ".Ok";
    private static final Pattern MESSAGE_START_PATTERN = Pattern.compile("^\\* (?<msn>\\d+) FETCH \\((?:(?:FLAGS \\((?<flags>[^)]*)\\)) |(?:UID (?<uid>\\d+)) ){0,2}BODY(?:\\.PEEK)?\\[\\] \\{(?<amount>\\d+)\\}", 2);
    private static final List<FetchData.Item> METADATA_ITEMS = Arrays.asList(FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.MODSEQ, FetchData.Item.UID);
    private final Session mailSession;
    private final IMailHandler mailHandler;

    public FetchProxyProcessor(Session session, IMailHandler mailHandler, StatusResponseFactory factory, ImapProcessor next) {
        super(FetchProxyRequest.class, factory, next);
        this.mailSession = session;
        this.mailHandler = mailHandler;
    }

    @Override
    protected void doProcess(ProxyProcessor.ProxyData<FetchProxyRequest> data) throws IOException {
        ProxyResponse proxyResponse;
        FetchProxyResponse fetchResponse = new FetchProxyResponse();
        fetchResponse.setFetchData(((FetchProxyRequest)((Object)data.request)).getFetch());
        if (this.isMetadataRequested((FetchProxyRequest)((Object)data.request))) {
            FetchProxyRequest metadataRequest = this.createMetadataRequest((FetchProxyRequest)((Object)data.request));
            proxyResponse = this.sendProxy(data.proxy, metadataRequest);
            if (!this.isOkResponse(proxyResponse, metadataRequest.getTag())) {
                data.response = proxyResponse;
                return;
            }
            this.parseMetadataResponse(proxyResponse, fetchResponse);
            this.removeOkResponse(fetchResponse, metadataRequest.getTag());
        }
        if (this.isMessageRequested((FetchProxyRequest)((Object)data.request))) {
            FetchProxyRequest messageRequest = this.createMessageRequest((FetchProxyRequest)((Object)data.request));
            proxyResponse = this.sendProxy(data.proxy, messageRequest);
            if (!this.isOkResponse(proxyResponse, messageRequest.getTag())) {
                data.response = proxyResponse;
                return;
            }
            try {
                this.parseMessageResponse(proxyResponse, fetchResponse);
            }
            catch (MessagingException e) {
                throw new IOException("Could not parse mime message.", e);
            }
            this.removeOkResponse(fetchResponse, messageRequest.getTag());
        }
        data.session.setAttribute(SESSION_OK_ID, (Object)Boolean.TRUE);
        data.response = fetchResponse;
    }

    @Override
    protected void doProcess(FetchProxyRequest request, ImapProcessor.Responder responder, ImapSession session) {
        session.setAttribute(SESSION_OK_ID, (Object)Boolean.FALSE);
        super.doProcess(request, responder, session);
        Boolean ok = (Boolean)session.getAttribute(SESSION_OK_ID);
        if (ok.booleanValue()) {
            StatusResponse okResponse = this.getFactory().taggedOk(request.getTag(), request.getActualCommand(), HumanReadableText.COMPLETED);
            responder.respond((ImapResponseMessage)okResponse);
        }
        session.setAttribute(SESSION_OK_ID, null);
    }

    private ProxyResponse sendProxy(IProxy<ProxyRequest, ProxyResponse> proxy, ProxyRequest request) throws IOException {
        ProxyResponse response = (ProxyResponse)proxy.send((IProxyRequest)request);
        LOG.debug("Received proxy response: {}", (Object)response);
        return response;
    }

    private boolean isOkResponse(ProxyResponse response, Tag tag) {
        Pattern pattern = Pattern.compile("^\\Q" + tag.asString() + "\\E OK", 2);
        String[] lines = response.getLines();
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (!pattern.matcher(line).find()) continue;
            return true;
        }
        return false;
    }

    private void removeOkResponse(FetchProxyResponse fetchResponse, Tag tag) {
        Pattern pattern = Pattern.compile("^\\Q" + tag.asString() + "\\E OK", 2);
        Iterator<String> iter = fetchResponse.getAdditionalLines().iterator();
        while (iter.hasNext()) {
            if (!pattern.matcher(iter.next()).find()) continue;
            iter.remove();
        }
    }

    private boolean isMetadataRequested(FetchProxyRequest request) {
        if (request.isUseUids()) {
            return true;
        }
        FetchData fetch = request.getFetch();
        return METADATA_ITEMS.stream().filter(arg_0 -> ((FetchData)fetch).contains(arg_0)).findAny().isPresent();
    }

    private FetchProxyRequest createMetadataRequest(FetchProxyRequest orgRequest) {
        FetchProxyRequest metaRequest = new FetchProxyRequest(orgRequest, orgRequest.getTag());
        FetchData orgFetch = orgRequest.getFetch();
        List items = METADATA_ITEMS.stream().filter(arg_0 -> ((FetchData)orgFetch).contains(arg_0)).collect(Collectors.toList());
        if (orgRequest.isUseUids() && !items.contains(FetchData.Item.UID)) {
            items.add(FetchData.Item.UID);
        }
        metaRequest.setFetch(FetchData.builder().fetch(items).build());
        LOG.debug("Create meta data request: {}", (Object)metaRequest);
        return metaRequest;
    }

    private void parseMetadataResponse(ProxyResponse proxyResponse, FetchProxyResponse fetchResponse) {
        String[] lines = proxyResponse.getLines();
        MetaDataParser parser = new MetaDataParser();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (parser.isMetaData(line)) {
                Map.Entry<MessageSequenceNumber, MessageMetaData> msnMetaData = parser.parse(line);
                fetchResponse.getMetadata().put(msnMetaData.getKey(), msnMetaData.getValue());
                continue;
            }
            fetchResponse.getAdditionalLines().add(line);
        }
        LOG.debug("Parsed meta data response: {}", (Object)fetchResponse);
    }

    private boolean isMessageRequested(FetchProxyRequest request) {
        return !request.getFetch().isOnlyFlags();
    }

    private FetchProxyRequest createMessageRequest(FetchProxyRequest orgRequest) {
        boolean peek = !orgRequest.getFetch().isSetSeen();
        FetchProxyRequest msgRequest = new FetchProxyRequest(orgRequest, orgRequest.getTag());
        msgRequest.setFetch(FetchData.builder().add(BodyFetchElement.createRFC822(), peek).build());
        LOG.debug("Created message request: {}", (Object)msgRequest);
        return msgRequest;
    }

    private void parseMessageResponse(ProxyResponse proxyResponse, FetchProxyResponse fetchResponse) throws IOException, MessagingException {
        String[] lines = proxyResponse.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            Matcher matcher = MESSAGE_START_PATTERN.matcher(line);
            if (matcher.find()) {
                MessageSequenceNumber msn = MessageSequenceNumber.of((int)Integer.parseInt(matcher.group("msn")));
                int amount = Integer.parseInt(matcher.group("amount"));
                MimeMessage msg = this.parseMessage(lines, i + 1, amount);
                this.logMessage(msg, msn);
                this.handleCryptography(msg);
                fetchResponse.getMessages().put(msn, msg);
                i = this.skipLinesTo(lines, i + 1, amount) - 1;
                continue;
            }
            fetchResponse.getAdditionalLines().add(line);
        }
        LOG.debug("Parsed message response: {}", (Object)fetchResponse);
    }

    private MimeMessage parseMessage(String[] lines, int lineStart, int amount) throws MessagingException, IOException {
        try (LinesInputStream is = new LinesInputStream(lines, lineStart, amount);){
            MimeMessage mimeMessage = new MimeMessage(this.mailSession, (InputStream)is);
            return mimeMessage;
        }
    }

    private void handleCryptography(MimeMessage msg) {
        this.mailHandler.handleMessage(msg);
    }

    private void logMessage(MimeMessage msg, MessageSequenceNumber msn) throws IOException, MessagingException {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)os);
        LOG.trace("Parsed message for sequence number: {}\n{}", (Object)msn, (Object)os.toString(StandardCharsets.US_ASCII));
    }

    private int skipLinesTo(String[] lines, int lineStart, int amount) {
        int skipped = amount;
        for (int i = lineStart; i < lines.length; ++i) {
            if (skipped < 0) {
                return i;
            }
            skipped -= lines[i].length() + 2;
        }
        return lines.length;
    }

    private static class LinesInputStream
    extends InputStream {
        private final String[] lines;
        private int lineIndex;
        private int restAmount;
        private byte[] currentBytes;
        private int byteIndex;
        private boolean prepareNextLine;

        public LinesInputStream(String[] lines, int startIndex, int byteAmount) {
            this.lines = lines;
            this.lineIndex = startIndex;
            this.restAmount = byteAmount;
            if (startIndex < 0) {
                throw new IllegalArgumentException("Start index cannot be negative.");
            }
            if (startIndex < lines.length) {
                this.currentBytes = lines[startIndex].getBytes(StandardCharsets.US_ASCII);
                ++this.lineIndex;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.restAmount <= 0) {
                return -1;
            }
            if (this.currentBytes == null) {
                throw new IOException("Unexpected end of stream reached.");
            }
            --this.restAmount;
            if (this.byteIndex < this.currentBytes.length) {
                return this.currentBytes[this.byteIndex++];
            }
            if (!this.prepareNextLine) {
                this.prepareNextLine = true;
                return 13;
            }
            this.prepareNextLine = false;
            if (this.lineIndex < this.lines.length) {
                this.currentBytes = this.lines[this.lineIndex++].getBytes(StandardCharsets.US_ASCII);
                this.byteIndex = 0;
            } else {
                this.currentBytes = null;
            }
            return 10;
        }
    }
}

