/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.processor.fetch;

import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Flags;
import javax.mail.internet.MailDateFormat;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.MessageMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataParser {
    private static final Logger LOG = LoggerFactory.getLogger(MetaDataParser.class);
    private static final Pattern METADATA_PATTERN = Pattern.compile("^\\* (?<msn>\\d+) (?<cmd>[a-z]+) \\((?<data>.+)\\)$", 2);
    private static final Pattern FLAGS_PATTERN = Pattern.compile("FLAGS \\(([^)]*)\\)", 2);
    private static final Pattern INTERNAL_DATE_PATTERN = Pattern.compile("INTERNALDATE \\\"([^\"]+)\\\"", 2);
    private static final Pattern MODSEQ_PATTERN = Pattern.compile("MODSEQ \\(?(\\d+)\\)?", 2);
    private static final Pattern UID_PATTERN = Pattern.compile("UID \\(?(\\d+)\\)?", 2);
    private static final Map<String, Flags.Flag> SYSTEM_FLAGS = new HashMap<String, Flags.Flag>();

    public boolean isMetaData(String line) {
        return line != null && METADATA_PATTERN.matcher(line).matches();
    }

    public Map.Entry<MessageSequenceNumber, MessageMetaData> parse(String line) {
        if (line == null) {
            return null;
        }
        Matcher metadataMatcher = METADATA_PATTERN.matcher(line);
        if (!metadataMatcher.matches()) {
            return null;
        }
        MessageSequenceNumber msn = MessageSequenceNumber.of((int)Integer.parseInt(metadataMatcher.group("msn")));
        String data = metadataMatcher.group("data");
        MessageUid uid = this.parseMessageUid(data);
        ModSeq modSeq = this.parseModSeq(data);
        Flags flags = this.parseFlags(data);
        Date internalDate = this.parseInternalDate(data);
        MessageMetaData metaData = new MessageMetaData(uid, modSeq, flags, 0L, internalDate, null, null);
        return new AbstractMap.SimpleEntry<MessageSequenceNumber, MessageMetaData>(msn, metaData);
    }

    private MessageUid parseMessageUid(String metadata) {
        Matcher matcher = UID_PATTERN.matcher(metadata);
        if (!matcher.find()) {
            return null;
        }
        return MessageUid.of((long)Long.parseLong(matcher.group(1)));
    }

    private ModSeq parseModSeq(String metadata) {
        Matcher matcher = MODSEQ_PATTERN.matcher(metadata);
        if (!matcher.find()) {
            return null;
        }
        return ModSeq.of((long)Long.parseLong(matcher.group(1)));
    }

    private Flags parseFlags(String metadata) {
        Matcher matcher = FLAGS_PATTERN.matcher(metadata);
        if (!matcher.find()) {
            return null;
        }
        Flags flags = new Flags();
        String flagsStr = matcher.group(1).trim().toUpperCase(Locale.ENGLISH);
        if (!flagsStr.isEmpty()) {
            for (String flagStr : flagsStr.split(" ")) {
                if (SYSTEM_FLAGS.containsKey(flagStr)) {
                    flags.add(SYSTEM_FLAGS.get(flagStr));
                    continue;
                }
                flags.add(flagStr);
            }
        }
        return flags;
    }

    private Date parseInternalDate(String metadata) {
        Matcher matcher = INTERNAL_DATE_PATTERN.matcher(metadata);
        if (!matcher.find()) {
            return null;
        }
        MailDateFormat formatter = new MailDateFormat();
        try {
            return formatter.parse(matcher.group(1));
        }
        catch (ParseException e) {
            LOG.error("Could not parse date. Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        SYSTEM_FLAGS.put("\\ANSWERED", Flags.Flag.ANSWERED);
        SYSTEM_FLAGS.put("\\DELETED", Flags.Flag.DELETED);
        SYSTEM_FLAGS.put("\\DRAFT", Flags.Flag.DRAFT);
        SYSTEM_FLAGS.put("\\FLAGGED", Flags.Flag.FLAGGED);
        SYSTEM_FLAGS.put("\\RECENT", Flags.Flag.RECENT);
        SYSTEM_FLAGS.put("\\SEEN", Flags.Flag.SEEN);
    }
}

