/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import net.savignano.uptrust.proxy.base.proxy.BaseProxy;
import net.savignano.uptrust.proxy.base.request.BaseProxyRequest;
import net.savignano.uptrust.proxy.base.response.BaseProxyResponse;
import net.savignano.uptrust.proxy.imap.request.IdlingProxyRequest;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import net.savignano.uptrust.proxy.imap.response.ProxyResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;

public class ImapProxy
extends BaseProxy<ProxyRequest, ProxyResponse> {
    public static final String PROXY_PARAM = ImapProxy.class.getCanonicalName();
    private static final String SERVER_BYE = "* BYE";

    public ImapProxy(InetSocketAddress address) {
        super(address);
    }

    protected BaseProxyResponse read(ProxyRequest request) throws IOException {
        if (request instanceof IdlingProxyRequest) {
            return this.readIdling();
        }
        return super.read((BaseProxyRequest)request);
    }

    private BaseProxyResponse readIdling() throws IOException {
        try {
            String line = this.getReader().readLine();
            this.getLog().trace("Read from {}: {}", (Object)this.getAddress(), (Object)line);
            return new BaseProxyResponse(line);
        }
        catch (SocketTimeoutException e) {
            this.getLog().trace("No server data.");
            return BaseProxyResponse.NO_RESPONSE;
        }
    }

    protected ProxyResponse toResponse(BaseProxyResponse response) {
        return new ProxyResponse(response);
    }

    protected void startTls() throws IOException {
        ProxyRequest request = new ProxyRequest(new Tag("tls"), ImapConstants.STARTTLS_COMMAND.getName(), null);
        this.getLog().debug("STARTTLS request: {}", (Object)request);
        this.write(request);
        BaseProxyResponse response = this.read(request);
        this.getLog().debug("STARTTLS response: {}", (Object)response);
        String[] lines = response.getLines();
        if (!StringUtils.startsWithIgnoreCase((CharSequence)lines[lines.length - 1], (CharSequence)"tls OK")) {
            throw new IOException("Failed to STARTTLS. Server answer: " + lines[lines.length - 1]);
        }
    }

    protected boolean isExpectMoreLines(String line, ProxyRequest request) {
        return !this.isContinuationResponse(line) && !this.isCommandFinished(line, request.getTag()) && !this.isServerEndCommunication(line, request.getActualCommand());
    }

    private boolean isContinuationResponse(String line) {
        return line.equals("+") || line.startsWith("+ ");
    }

    private boolean isCommandFinished(String line, Tag expectedTag) {
        String tag = expectedTag.asString() + " ";
        return line.length() >= tag.length() && line.substring(0, tag.length()).equalsIgnoreCase(tag);
    }

    private boolean isServerEndCommunication(String line, ImapCommand command) {
        if (ImapConstants.LOGOUT_COMMAND.getName().equalsIgnoreCase(command.getName())) {
            return false;
        }
        return line.length() >= 5 && line.substring(0, 5).equalsIgnoreCase(SERVER_BYE);
    }
}

