/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.proxy;

import net.savignano.uptrust.proxy.base.proxy.ETransportSecurity;

public class ImapProxyConfiguration {
    private final String host;
    private final int port;
    private final ETransportSecurity transportSecurity;

    private ImapProxyConfiguration(String host, int port, ETransportSecurity transportSecurity) {
        this.host = host;
        this.port = port;
        this.transportSecurity = transportSecurity;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ETransportSecurity getTransportSecurity() {
        return this.transportSecurity;
    }

    public static final class ImapProxyConfigurationBuilder {
        public static final int DEFAULT_IMAP_PORT = 143;
        private String host = "localhost";
        private int port = 143;
        private ETransportSecurity transportSecurity = ETransportSecurity.START_TLS;

        public static ImapProxyConfigurationBuilder builder() {
            return new ImapProxyConfigurationBuilder();
        }

        public ImapProxyConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ImapProxyConfigurationBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ImapProxyConfigurationBuilder transportSecurity(ETransportSecurity transportSecurity) {
            this.transportSecurity = transportSecurity;
            return this;
        }

        public ImapProxyConfiguration build() {
            return new ImapProxyConfiguration(this.host, this.port, this.transportSecurity);
        }
    }
}

