/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.request;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import net.savignano.uptrust.proxy.imap.request.ProxyRequest;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;

public class FetchProxyRequest
extends ProxyRequest {
    private boolean useUids;
    private IdRange[] idSet;
    private FetchData fetch;

    public FetchProxyRequest(Tag tag) {
        super(tag, ImapConstants.FETCH_COMMAND.getName(), null);
    }

    public FetchProxyRequest(FetchProxyRequest request) {
        this(request, request.getTag());
    }

    public FetchProxyRequest(FetchProxyRequest request, Tag tag) {
        super(tag, ImapConstants.FETCH_COMMAND.getName(), null);
        this.setExpectingServerData(request.isExpectingServerData());
        this.setLiteralData(request.isLiteralData());
        this.setIdSet(request.getIdSet());
        this.setFetch(request.getFetch());
        this.setUseUids(request.isUseUids());
    }

    public boolean isUseUids() {
        return this.useUids;
    }

    public void setUseUids(boolean useUids) {
        this.useUids = useUids;
    }

    public IdRange[] getIdSet() {
        return this.idSet;
    }

    public void setIdSet(IdRange[] idSet) {
        this.idSet = idSet;
    }

    public FetchData getFetch() {
        return this.fetch;
    }

    public void setFetch(FetchData fetch) {
        this.fetch = fetch;
    }

    @Override
    public String getTransferData() {
        StringBuilder builder = new StringBuilder(50);
        this.addCommand(builder);
        this.addIdRanges(builder);
        this.addFetch(builder);
        return builder.toString();
    }

    private void addCommand(StringBuilder builder) {
        builder.append(this.getTag().asString());
        if (this.isUseUids()) {
            builder.append(" UID");
        }
        builder.append(' ');
        builder.append(this.getActualCommand().getName());
    }

    private void addIdRanges(StringBuilder builder) {
        builder.append(' ');
        IdRange[] idRanges = this.getIdSet();
        if (idRanges == null || idRanges.length == 0) {
            builder.append('*');
        } else {
            for (IdRange range : idRanges) {
                this.addIdRange(range, builder);
                builder.append(',');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
    }

    private void addIdRange(IdRange idRange, StringBuilder builder) {
        long high;
        long low = idRange.getLowVal();
        if (low == (high = idRange.getHighVal())) {
            this.addId(low, builder);
        } else {
            this.addId(low, builder);
            builder.append(':');
            this.addId(high, builder);
        }
    }

    private void addId(long id, StringBuilder builder) {
        if (id == Long.MAX_VALUE) {
            builder.append('*');
        } else {
            builder.append(id);
        }
    }

    private void addFetch(StringBuilder builder) {
        FetchData fetch = this.getFetch();
        builder.append(' ');
        builder.append('(');
        if (fetch.contains(FetchData.Item.FLAGS)) {
            builder.append("FLAGS ");
        }
        if (fetch.contains(FetchData.Item.INTERNAL_DATE)) {
            builder.append("INTERNALDATE ");
        }
        if (fetch.contains(FetchData.Item.MODSEQ)) {
            builder.append("MODSEQ ");
        }
        if (fetch.contains(FetchData.Item.UID)) {
            builder.append("UID ");
        }
        if (!fetch.isOnlyFlags()) {
            builder.append("BODY");
            if (!fetch.isSetSeen()) {
                builder.append(".PEEK");
            }
            builder.append("[]");
        }
        if (builder.charAt(builder.length() - 1) == ' ') {
            builder.setLength(builder.length() - 1);
        }
        builder.append(')');
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("useUids", this.isUseUids()).add("idSet", (Object)Arrays.toString(this.getIdSet())).add("fetch", (Object)this.getFetch()).add("literalData", this.isLiteralData()).add("expectingServerData", this.isExpectingServerData()).add("transferData", (Object)this.getTransferData()).toString();
    }
}

