/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.request;

import net.savignano.uptrust.proxy.base.request.BaseProxyRequest;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.request.ImapRequest;

public class ProxyRequest
extends BaseProxyRequest
implements ImapRequest {
    private final Tag tag;
    private final ImapCommand command;
    private final ImapCommand actualCommand;

    public ProxyRequest(Tag tag, String data) {
        this(tag, "<N/A>", data);
        this.setLiteralData(true);
    }

    public ProxyRequest(Tag tag, String command, String data) {
        super(data);
        this.tag = tag;
        this.command = ImapCommand.anyStateCommand((String)"PROXY");
        this.actualCommand = ImapCommand.anyStateCommand((String)command);
    }

    public ImapCommand getActualCommand() {
        return this.actualCommand;
    }

    public String getTransferData() {
        if (this.isLiteralData()) {
            return this.getData();
        }
        StringBuilder builder = new StringBuilder(50);
        builder.append(this.getTag().asString());
        builder.append(' ');
        builder.append(this.getActualCommand().getName());
        if (this.getData() != null) {
            builder.append(' ');
            builder.append(this.getData());
        }
        return builder.toString();
    }

    public ImapCommand getCommand() {
        return this.command;
    }

    public Tag getTag() {
        return this.tag;
    }
}

