/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.imap.response;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.MimeMessage;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.model.MessageMetaData;

public class FetchProxyResponse
implements ImapResponseMessage {
    private final Map<MessageSequenceNumber, MimeMessage> messages;
    private final Map<MessageSequenceNumber, MessageMetaData> metaData;
    private final List<String> additionalLines;
    private FetchData fetchData;

    public FetchProxyResponse() {
        this(null, null, null);
    }

    public FetchProxyResponse(Map<MessageSequenceNumber, MimeMessage> messages, Map<MessageSequenceNumber, MessageMetaData> metaData, List<String> additionalLines) {
        this.messages = messages == null ? new TreeMap<MessageSequenceNumber, MimeMessage>() : new TreeMap<MessageSequenceNumber, MimeMessage>(messages);
        this.metaData = metaData == null ? new TreeMap<MessageSequenceNumber, MessageMetaData>() : new TreeMap<MessageSequenceNumber, MessageMetaData>(metaData);
        this.additionalLines = additionalLines == null ? new ArrayList<String>(5) : new ArrayList<String>(additionalLines);
    }

    public Map<MessageSequenceNumber, MimeMessage> getMessages() {
        return this.messages;
    }

    public Map<MessageSequenceNumber, MessageMetaData> getMetadata() {
        return this.metaData;
    }

    public List<String> getAdditionalLines() {
        return this.additionalLines;
    }

    public FetchData getFetchData() {
        return this.fetchData;
    }

    public void setFetchData(FetchData fetchData) {
        this.fetchData = fetchData;
    }

    public String toString() {
        List<String> lines = this.getAdditionalLines();
        StringBuilder builder = new StringBuilder(50 * lines.size() + 7);
        if (lines.isEmpty()) {
            builder.append("<empty>");
        } else {
            for (String line : lines) {
                builder.append('\n');
                builder.append(line);
            }
        }
        return MoreObjects.toStringHelper((Object)this).add("messages", this.getMessages().keySet()).add("additionalLines", (Object)builder.toString()).toString();
    }
}

