/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.uptrust.proxy.base.proxy.ETransportSecurity;
import net.savignano.uptrust.proxy.imap.proxy.ImapProxyConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imapserver.netty.IMAPServerMBean;
import org.apache.james.imapserver.netty.ImapChannelUpstreamHandler;
import org.apache.james.imapserver.netty.ImapIdleStateHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.ImapRequestFrameDecoder;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoderFactory;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.ChannelGroupHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.apache.james.util.Size;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMAPServer
extends AbstractConfigurableAsyncServer
implements ImapConstants,
IMAPServerMBean,
NettyConstants {
    private static final Logger LOG = LoggerFactory.getLogger(IMAPServer.class);
    private static final String SOFTWARE_TYPE = "JAMES IMAP4rev1 Server ";
    private static final String DEFAULT_TIME_UNIT = "SECONDS";
    private static final String CAPABILITY_SEPARATOR = "|";
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapDecoder decoder;
    private final ImapMetrics imapMetrics;
    private String hello;
    private boolean compress;
    private int maxLineLength;
    private int inMemorySizeLimit;
    private int timeout;
    private int literalSizeLimit;
    private ImapProxyConfiguration proxyConfiguration;
    private AuthenticationConfiguration authenticationConfiguration;
    public static final int DEFAULT_MAX_LINE_LENGTH = 65536;
    public static final Size DEFAULT_IN_MEMORY_SIZE_LIMIT = Size.of((Long)10L, (Size.Unit)Size.Unit.M);
    public static final int DEFAULT_TIMEOUT = 1800;
    public static final int DEFAULT_LITERAL_SIZE_LIMIT = 0;

    public IMAPServer(ImapDecoder decoder, ImapEncoder encoder, ImapProcessor processor, ImapMetrics imapMetrics) {
        this.processor = processor;
        this.encoder = encoder;
        this.decoder = decoder;
        this.imapMetrics = imapMetrics;
        SecurityUtil.getProvider();
    }

    public void doConfigure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        this.hello = SOFTWARE_TYPE + this.getHelloName() + " is ready.";
        this.compress = configuration.getBoolean("compress", false);
        this.maxLineLength = configuration.getInt("maxLineLength", 65536);
        this.inMemorySizeLimit = Math.toIntExact(Optional.ofNullable(configuration.getString("inMemorySizeLimit", null)).map(Size::parse).orElse(DEFAULT_IN_MEMORY_SIZE_LIMIT).asBytes());
        this.literalSizeLimit = Optional.ofNullable(configuration.getString("literalSizeLimit", null)).map(Size::parse).map(Size::asBytes).map(Math::toIntExact).orElse(0);
        this.timeout = configuration.getInt("timeout", 1800);
        if (this.timeout < 1800) {
            throw new ConfigurationException("Minimum timeout of 30 minutes required. See rfc2060 5.4 for details");
        }
        this.authenticationConfiguration = AuthenticationConfiguration.parse(configuration);
        this.proxyConfiguration = IMAPServer.getImapProxyConfiguration(configuration);
        LOG.info("Binding \"{}\" as proxy for: {}:{}", new Object[]{this.jmxName, this.proxyConfiguration.getHost(), this.proxyConfiguration.getPort()});
        if (this.proxyConfiguration.getHost().equalsIgnoreCase("localhost") || this.proxyConfiguration.getHost().equals("127.0.0.1")) {
            LOG.debug("Remote server to connect to is on localhost. Check that ports are different. Addresses: {}", (Object)this.getListenAddressesBeforeBind());
            for (InetSocketAddress address : this.getListenAddressesBeforeBind()) {
                if (address.getPort() != this.proxyConfiguration.getPort()) continue;
                throw new ConfigurationException("Conflict on port " + this.proxyConfiguration.getPort() + ". Remote IMAP server is configured to be on Localhost and uses same port as this server. This will result in a connection loop.");
            }
        }
        this.processor.configure(IMAPServer.getImapConfiguration(configuration));
    }

    @VisibleForTesting
    static ImapConfiguration getImapConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) {
        ImmutableSet disabledCaps = ImmutableSet.copyOf((Iterable)Splitter.on((String)CAPABILITY_SEPARATOR).split((CharSequence)configuration.getString("disabledCaps", "")));
        return ImapConfiguration.builder().enableIdle(Boolean.valueOf(configuration.getBoolean("enableIdle", true))).idleTimeInterval(configuration.getLong("idleTimeInterval", 120L)).idleTimeIntervalUnit(IMAPServer.getTimeIntervalUnit(configuration.getString("idleTimeIntervalUnit", DEFAULT_TIME_UNIT))).disabledCaps(disabledCaps).build();
    }

    private static ImapProxyConfiguration getImapProxyConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        HierarchicalConfiguration proxyConfig = configuration.configurationAt("proxyFor");
        ImapProxyConfiguration.ImapProxyConfigurationBuilder builder = ImapProxyConfiguration.ImapProxyConfigurationBuilder.builder();
        if (proxyConfig.containsKey("host")) {
            builder.host(proxyConfig.getString("host"));
        }
        if (proxyConfig.containsKey("port")) {
            builder.port(proxyConfig.getInt("port"));
        }
        if (proxyConfig.containsKey("tls")) {
            String tls;
            switch (tls = proxyConfig.getString("tls").toLowerCase()) {
                case "disabled": {
                    builder.transportSecurity(ETransportSecurity.NONE);
                    break;
                }
                case "enabled": {
                    builder.transportSecurity(ETransportSecurity.TLS);
                    break;
                }
                case "starttls": {
                    builder.transportSecurity(ETransportSecurity.START_TLS);
                    break;
                }
                default: {
                    throw new ConfigurationException("Unknown value (\"" + tls + "\") for transport layer security (tls). Possible values are: enabled, disabled, starttls");
                }
            }
        }
        return builder.build();
    }

    private static TimeUnit getTimeIntervalUnit(String timeIntervalUnit) {
        try {
            return TimeUnit.valueOf(timeIntervalUnit);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Time interval unit is not valid {}, the default {} value should be used", (Object)timeIntervalUnit, (Object)ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT);
            return ImapConfiguration.DEFAULT_HEARTBEAT_INTERVAL_UNIT;
        }
    }

    public int getDefaultPort() {
        return 143;
    }

    public String getServiceType() {
        return "IMAP Service";
    }

    protected ChannelPipelineFactory createPipelineFactory(final ChannelGroup group) {
        return new ChannelPipelineFactory(){
            private final ChannelGroupHandler groupHandler;
            private final HashedWheelTimer timer;
            private final TimeUnit timeoutUnit;
            {
                this.groupHandler = new ChannelGroupHandler(group);
                this.timer = new HashedWheelTimer();
                this.timeoutUnit = TimeUnit.SECONDS;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("groupHandler", (ChannelHandler)this.groupHandler);
                pipeline.addLast("idleHandler", (ChannelHandler)new IdleStateHandler((Timer)this.timer, 0L, 0L, (long)IMAPServer.this.timeout, this.timeoutUnit));
                pipeline.addLast("timeoutHandler", (ChannelHandler)new ImapIdleStateHandler());
                pipeline.addLast("connectionLimitHandler", (ChannelHandler)new ConnectionLimitUpstreamHandler(IMAPServer.this.connectionLimit));
                pipeline.addLast("connectionPerIpLimitHandler", (ChannelHandler)new ConnectionPerIpLimitUpstreamHandler(IMAPServer.this.connPerIP));
                pipeline.addLast("framer", IMAPServer.this.getFrameHandlerFactory().create(pipeline));
                Encryption secure = IMAPServer.this.getEncryption();
                if (secure != null && !secure.isStartTLS()) {
                    SSLEngine engine = secure.createSSLEngine();
                    engine.setUseClientMode(false);
                    pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("connectionCountHandler", (ChannelHandler)IMAPServer.this.getConnectionCountHandler());
                pipeline.addLast("chunkWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
                ExecutionHandler ehandler = IMAPServer.this.getExecutionHandler();
                if (ehandler != null) {
                    pipeline.addLast("executionHandler", (ChannelHandler)ehandler);
                }
                pipeline.addLast("requestDecoder", (ChannelHandler)new ImapRequestFrameDecoder(IMAPServer.this.decoder, IMAPServer.this.inMemorySizeLimit, IMAPServer.this.literalSizeLimit));
                pipeline.addLast("coreHandler", (ChannelHandler)IMAPServer.this.createCoreHandler());
                return pipeline;
            }
        };
    }

    protected String getDefaultJMXName() {
        return "imapserver";
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        Encryption secure = this.getEncryption();
        ImapChannelUpstreamHandler.ImapChannelUpstreamHandlerBuilder coreHandlerBuilder = ImapChannelUpstreamHandler.builder().hello(this.hello).proxyConfiguration(this.proxyConfiguration).processor(this.processor).encoder(this.encoder).compress(this.compress).authenticationConfiguration(this.authenticationConfiguration).secure(secure).imapMetrics(this.imapMetrics);
        if (secure != null && secure.isStartTLS()) {
            coreHandlerBuilder.secure(secure);
        }
        return coreHandlerBuilder.build();
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new SwitchableLineBasedFrameDecoderFactory(this.maxLineLength);
    }

    public static class AuthenticationConfiguration {
        private static final boolean PLAIN_AUTH_DISALLOWED_DEFAULT = true;
        private static final boolean PLAIN_AUTH_ENABLED_DEFAULT = true;
        private static final String OIDC_PATH = "auth.oidc";
        private final boolean isSSLRequired;
        private final boolean plainAuthEnabled;
        private final Optional<OidcSASLConfiguration> oidcSASLConfiguration;

        public static AuthenticationConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
            boolean isRequireSSL = configuration.getBoolean("auth.requireSSL", AuthenticationConfiguration.fallback(configuration));
            boolean isPlainAuthEnabled = configuration.getBoolean("auth.plainAuthEnabled", true);
            if (configuration.immutableConfigurationsAt(OIDC_PATH).isEmpty()) {
                return new AuthenticationConfiguration(isRequireSSL, isPlainAuthEnabled);
            }
            try {
                return new AuthenticationConfiguration(isRequireSSL, isPlainAuthEnabled, OidcSASLConfiguration.parse((HierarchicalConfiguration)configuration.configurationAt(OIDC_PATH)));
            }
            catch (NullPointerException | MalformedURLException exception) {
                throw new ConfigurationException("Failed to retrieve oauth component", (Throwable)exception);
            }
        }

        private static boolean fallback(HierarchicalConfiguration<ImmutableNode> configuration) {
            return configuration.getBoolean("plainAuthDisallowed", true);
        }

        public AuthenticationConfiguration(boolean isSSLRequired, boolean plainAuthEnabled) {
            this.isSSLRequired = isSSLRequired;
            this.plainAuthEnabled = plainAuthEnabled;
            this.oidcSASLConfiguration = Optional.empty();
        }

        public AuthenticationConfiguration(boolean isSSLRequired, boolean plainAuthEnabled, OidcSASLConfiguration oidcSASLConfiguration) {
            this.isSSLRequired = isSSLRequired;
            this.plainAuthEnabled = plainAuthEnabled;
            this.oidcSASLConfiguration = Optional.of(oidcSASLConfiguration);
        }

        public boolean isSSLRequired() {
            return this.isSSLRequired;
        }

        public boolean isPlainAuthEnabled() {
            return this.plainAuthEnabled;
        }

        public Optional<OidcSASLConfiguration> getOidcSASLConfiguration() {
            return this.oidcSASLConfiguration;
        }
    }
}

