/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.response.IProxyResponse;
import net.savignano.uptrust.proxy.imap.processor.CapabilityProxyProcessor;
import net.savignano.uptrust.proxy.imap.proxy.ImapProxy;
import net.savignano.uptrust.proxy.imap.proxy.ImapProxyConfiguration;
import net.savignano.uptrust.proxy.imap.proxy.ImapProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.main.ResponseEncoder;
import org.apache.james.imapserver.netty.ChannelImapResponseWriter;
import org.apache.james.imapserver.netty.IMAPMDCContext;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.ImapHeartbeatHandler;
import org.apache.james.imapserver.netty.ImapMetrics;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapSession;
import org.apache.james.metrics.api.Metric;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.util.MDCBuilder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapChannelUpstreamHandler
extends SimpleChannelUpstreamHandler
implements NettyConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapChannelUpstreamHandler.class);
    private static final String CAPABILITY = "[" + ImapConstants.CAPABILITY_COMMAND.getName() + " ";
    public static final String MDC_KEY = "bound_MDC";
    private final String hello;
    private final Encryption secure;
    private final boolean compress;
    private final ImapProxyConfiguration proxyConfiguration;
    private final ImapProcessor processor;
    private final ImapEncoder encoder;
    private final ImapHeartbeatHandler heartbeatHandler = new ImapHeartbeatHandler();
    private final IMAPServer.AuthenticationConfiguration authenticationConfiguration;
    private final Metric imapConnectionsMetric;
    private final Metric imapCommandsMetric;

    public static ImapChannelUpstreamHandlerBuilder builder() {
        return new ImapChannelUpstreamHandlerBuilder();
    }

    public ImapChannelUpstreamHandler(String hello, ImapProxyConfiguration proxyConfiguration, ImapProcessor processor, ImapEncoder encoder, boolean compress, Encryption secure, ImapMetrics imapMetrics, IMAPServer.AuthenticationConfiguration authenticationConfiguration) {
        this.hello = hello;
        this.proxyConfiguration = proxyConfiguration;
        this.processor = processor;
        this.encoder = encoder;
        this.secure = secure;
        this.compress = compress;
        this.authenticationConfiguration = authenticationConfiguration;
        this.imapConnectionsMetric = imapMetrics.getConnectionsMetric();
        this.imapCommandsMetric = imapMetrics.getCommandsMetric();
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        NettyImapSession imapsession = new NettyImapSession(ctx.getChannel(), this.secure, this.compress, this.authenticationConfiguration.isSSLRequired(), this.authenticationConfiguration.isPlainAuthEnabled(), ImapSession.SessionId.generate(), this.authenticationConfiguration.getOidcSASLConfiguration());
        MDCBuilder boundMDC = IMAPMDCContext.boundMDC(ctx);
        imapsession.setAttribute(MDC_KEY, boundMDC);
        imapsession.setAttribute(ImapProxy.PROXY_PARAM, this.createProxy());
        attributes.set(ctx.getChannel(), (Object)imapsession);
        try (Closeable closeable = boundMDC.build();){
            super.channelBound(ctx, e);
        }
    }

    private MDCBuilder mdc(ChannelHandlerContext ctx) {
        ImapSession maybeSession = (ImapSession)attributes.get(ctx.getChannel());
        return Optional.ofNullable(maybeSession).map(session -> {
            MDCBuilder boundMDC = (MDCBuilder)session.getAttribute(MDC_KEY);
            return IMAPMDCContext.from(session).addToContext(boundMDC);
        }).orElseGet(MDCBuilder::create);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            LOGGER.info("Connection closed for {}", (Object)address.getAddress().getHostAddress());
            ImapSession imapSession = (ImapSession)attributes.remove(ctx.getChannel());
            if (imapSession != null) {
                this.closeProxy((IProxy<?, ?>)this.getProxy(imapSession));
                imapSession.logout();
            }
            this.imapConnectionsMetric.decrement();
            super.channelClosed(ctx, e);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            InetSocketAddress address = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            LOGGER.info("Connection established from {}", (Object)address.getAddress().getHostAddress());
            this.imapConnectionsMetric.increment();
            ImapResponseComposerImpl response = new ImapResponseComposerImpl((ImapResponseWriter)new ChannelImapResponseWriter(ctx.getChannel()));
            ctx.setAttachment((Object)response);
            ImapSession imapSession = (ImapSession)attributes.get(ctx.getChannel());
            this.connectProxy(imapSession, (ImapResponseComposer)response);
            super.channelConnected(ctx, e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            LOGGER.warn("Error while processing imap request", e.getCause());
            if (e.getCause() instanceof TooLongFrameException) {
                ImapResponseComposer composer = (ImapResponseComposer)ctx.getAttachment();
                composer.untaggedResponse("BAD failed. Maximum command line length exceeded");
            } else {
                Channel channel;
                ImapSession imapSession = (ImapSession)attributes.get(ctx.getChannel());
                if (imapSession != null) {
                    this.closeProxy((IProxy<?, ?>)this.getProxy(imapSession));
                    imapSession.logout();
                }
                if ((channel = ctx.getChannel()).isConnected()) {
                    channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            this.imapCommandsMetric.increment();
            ImapSession session = (ImapSession)attributes.get(ctx.getChannel());
            ImapResponseComposer response = (ImapResponseComposer)ctx.getAttachment();
            ImapMessage message = (ImapMessage)event.getMessage();
            ChannelPipeline cp = ctx.getPipeline();
            try {
                IOException failure;
                Channel channel;
                try {
                    if (cp.get("executionHandler") != null) {
                        cp.addBefore("executionHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
                    } else {
                        cp.addBefore("coreHandler", "heartbeatHandler", (ChannelHandler)this.heartbeatHandler);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.info("heartbeat handler is already part of this pipeline", (Throwable)e);
                }
                ResponseEncoder responseEncoder = new ResponseEncoder(this.encoder, response);
                this.processor.process(message, (ImapProcessor.Responder)responseEncoder, session);
                if (session.getState() == ImapSessionState.LOGOUT && (channel = ctx.getChannel()).isConnected()) {
                    channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
                }
                if ((failure = responseEncoder.getFailure()) != null) {
                    LOGGER.info(failure.getMessage());
                    LOGGER.debug("Failed to write {}", (Object)message, (Object)failure);
                    throw failure;
                }
            }
            finally {
                try {
                    ctx.getPipeline().remove("heartbeatHandler");
                }
                catch (NoSuchElementException e) {
                    LOGGER.info("Heartbeat handler was concurrently removed");
                }
                if (message instanceof Closeable) {
                    ((Closeable)message).close();
                }
            }
            super.messageReceived(ctx, event);
        }
    }

    private ImapProxy getProxy(ImapSession imapSession) {
        return (ImapProxy)imapSession.getAttribute(ImapProxy.PROXY_PARAM);
    }

    private ImapProxy createProxy() {
        return ImapProxyFactory.create((ImapProxyConfiguration)this.proxyConfiguration);
    }

    private void connectProxy(ImapSession imapSession, ImapResponseComposer response) throws IOException {
        IProxyResponse greeting;
        ImapProxy proxy = this.getProxy(imapSession);
        LOGGER.info("Connecting to mail server at: {}", (Object)proxy.getAddress());
        try {
            greeting = proxy.connect();
        }
        catch (IOException e1) {
            String message = "Could not connect to mail server at: " + String.valueOf(proxy.getAddress());
            try {
                response.untagged().message("BAD").message(message).end();
            }
            catch (Exception e2) {
                LOGGER.error(e2.getMessage(), (Throwable)e2);
            }
            throw new IOException(message, e1);
        }
        if (greeting.getLines().length != 1) {
            String message = "Unexpected server greeting. Received: " + Arrays.toString(greeting.getLines());
            throw new IOException(message);
        }
        String greetingLine = this.processGreeting(greeting.getLines()[0], imapSession);
        response.skipNextSpace().message(greetingLine).end();
    }

    private String processGreeting(String greeting, ImapSession imapSession) {
        int capaEnd;
        int capaStart = StringUtils.indexOfIgnoreCase((CharSequence)greeting, (CharSequence)CAPABILITY);
        if (capaStart != -1 && (capaEnd = StringUtils.indexOf((CharSequence)greeting, (int)93, (int)capaStart)) != -1) {
            String capaPart = greeting.substring(capaStart, capaEnd);
            capaPart = CapabilityProxyProcessor.adjustCapabilities((String)capaPart, (ImapSession)imapSession, (Logger)LOGGER);
            return greeting.substring(0, capaStart) + capaPart + greeting.substring(capaEnd);
        }
        return greeting;
    }

    private void closeProxy(IProxy<?, ?> proxy) {
        if (proxy == null) {
            return;
        }
        LOGGER.info("Closing connection to mail server at: {}", (Object)proxy.getAddress());
        proxy.close();
    }

    public static class ImapChannelUpstreamHandlerBuilder {
        private String hello;
        private Encryption secure;
        private boolean compress;
        private ImapProxyConfiguration proxyConfiguration;
        private ImapProcessor processor;
        private ImapEncoder encoder;
        private IMAPServer.AuthenticationConfiguration authenticationConfiguration;
        private ImapMetrics imapMetrics;

        public ImapChannelUpstreamHandlerBuilder hello(String hello) {
            this.hello = hello;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder secure(Encryption secure) {
            this.secure = secure;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder proxyConfiguration(ImapProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder processor(ImapProcessor processor) {
            this.processor = processor;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder encoder(ImapEncoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder authenticationConfiguration(IMAPServer.AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public ImapChannelUpstreamHandlerBuilder imapMetrics(ImapMetrics imapMetrics) {
            this.imapMetrics = imapMetrics;
            return this;
        }

        public ImapChannelUpstreamHandler build() {
            return new ImapChannelUpstreamHandler(this.hello, this.proxyConfiguration, this.processor, this.encoder, this.compress, this.secure, this.imapMetrics, this.authenticationConfiguration);
        }
    }
}

