/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imapserver.netty.ImapLineHandlerAdapter;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyImapSession
implements ImapSession,
NettyConstants {
    private ImapSessionState state = ImapSessionState.NON_AUTHENTICATED;
    private SelectedMailbox selectedMailbox;
    private final Map<String, Object> attributesByKey = new HashMap<String, Object>();
    private final Encryption secure;
    private final boolean compress;
    private final Channel channel;
    private int handlerCount;
    private final boolean requiredSSL;
    private final boolean plainAuthEnabled;
    private final ImapSession.SessionId sessionId;
    private boolean needsCommandInjectionDetection;
    private Optional<OidcSASLConfiguration> oidcSASLConfiguration;
    private boolean supportsOAuth;

    public NettyImapSession(Channel channel, Encryption secure, boolean compress, boolean requiredSSL, boolean plainAuthEnabled, ImapSession.SessionId sessionId, Optional<OidcSASLConfiguration> oidcSASLConfiguration) {
        this.channel = channel;
        this.secure = secure;
        this.compress = compress;
        this.requiredSSL = requiredSSL;
        this.plainAuthEnabled = plainAuthEnabled;
        this.sessionId = sessionId;
        this.needsCommandInjectionDetection = true;
        this.oidcSASLConfiguration = oidcSASLConfiguration;
        this.supportsOAuth = oidcSASLConfiguration.isPresent();
    }

    public boolean needsCommandInjectionDetection() {
        return this.needsCommandInjectionDetection;
    }

    public void startDetectingCommandInjection() {
        this.needsCommandInjectionDetection = true;
    }

    public void stopDetectingCommandInjection() {
        this.needsCommandInjectionDetection = false;
    }

    public ImapSession.SessionId sessionId() {
        return this.sessionId;
    }

    public void logout() {
        this.closeMailbox();
        this.state = ImapSessionState.LOGOUT;
    }

    public void authenticated() {
        this.state = ImapSessionState.AUTHENTICATED;
    }

    public void deselect() {
        this.state = ImapSessionState.AUTHENTICATED;
        this.closeMailbox();
    }

    public void selected(SelectedMailbox mailbox) {
        this.state = ImapSessionState.SELECTED;
        this.closeMailbox();
        this.selectedMailbox = mailbox;
    }

    public SelectedMailbox getSelected() {
        return this.selectedMailbox;
    }

    public ImapSessionState getState() {
        return this.state;
    }

    private void closeMailbox() {
        if (this.selectedMailbox != null) {
            this.selectedMailbox.deselect();
            this.selectedMailbox = null;
        }
    }

    public Object getAttribute(String key) {
        return this.attributesByKey.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributesByKey.remove(key);
        } else {
            this.attributesByKey.put(key, value);
        }
    }

    public boolean startTLS() {
        if (!this.supportStartTLS()) {
            return false;
        }
        this.channel.setReadable(false);
        SslHandler filter = new SslHandler(this.secure.createSSLEngine(), false);
        filter.getEngine().setUseClientMode(false);
        this.channel.getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
        this.channel.setReadable(true);
        return true;
    }

    public boolean supportStartTLS() {
        return this.secure != null && this.secure.getContext() != null;
    }

    public boolean enforceStartTLS() {
        return this.secure != null && this.secure.isEnforceStartTLS();
    }

    public boolean isCompressionSupported() {
        return this.compress;
    }

    public boolean startCompression() {
        if (!this.isCompressionSupported()) {
            return false;
        }
        this.channel.setReadable(false);
        ZlibDecoder decoder = new ZlibDecoder(ZlibWrapper.NONE);
        ZlibEncoder encoder = new ZlibEncoder(ZlibWrapper.NONE, 5);
        if (this.channel.getPipeline().get("sslHandler") == null) {
            this.channel.getPipeline().addFirst("zlibDecoder", (ChannelHandler)decoder);
            this.channel.getPipeline().addFirst("zlibEncoder", (ChannelHandler)encoder);
        } else {
            this.channel.getPipeline().addAfter("sslHandler", "zlibDecoder", (ChannelHandler)decoder);
            this.channel.getPipeline().addAfter("sslHandler", "zlibEncoder", (ChannelHandler)encoder);
        }
        this.channel.setReadable(true);
        return true;
    }

    public void pushLineHandler(ImapLineHandler lineHandler) {
        this.channel.setReadable(false);
        this.channel.getPipeline().addBefore("requestDecoder", "lineHandler" + this.handlerCount++, (ChannelHandler)new ImapLineHandlerAdapter(this, lineHandler));
        this.channel.setReadable(true);
    }

    public void popLineHandler() {
        this.channel.setReadable(false);
        this.channel.getPipeline().remove("lineHandler" + --this.handlerCount);
        this.channel.setReadable(true);
    }

    public boolean isSSLRequired() {
        return this.requiredSSL;
    }

    public boolean isPlainAuthEnabled() {
        return this.plainAuthEnabled;
    }

    public boolean supportsOAuth() {
        return this.supportsOAuth;
    }

    public Optional<OidcSASLConfiguration> oidcSaslConfiguration() {
        return this.oidcSASLConfiguration;
    }

    public boolean isTLSActive() {
        return this.channel.getPipeline().get("sslHandler") != null;
    }

    public boolean supportMultipleNamespaces() {
        return false;
    }

    public boolean isCompressionActive() {
        return this.channel.getPipeline().get("zlibDecoder") != null;
    }
}

