/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import javax.inject.Singleton;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.modules.CleanupTaskModule;
import org.apache.james.modules.ClockModule;
import org.apache.james.modules.MimeMessageModule;
import org.apache.james.modules.PeriodicalHealthChecksModule;
import org.apache.james.modules.StartUpChecksModule;
import org.apache.james.modules.StartablesModule;
import org.apache.james.modules.UptrustModule;
import org.apache.james.modules.server.DNSServiceModule;
import org.apache.james.modules.server.DropWizardMetricsModule;
import org.apache.james.onami.lifecycle.PreDestroyModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.ExtensionModule;
import org.apache.james.utils.GuiceProbe;

public class CommonServicesModule
extends AbstractModule {
    private final Configuration configuration;
    private final FileSystemImpl fileSystem;

    public CommonServicesModule(Configuration configuration) {
        this.configuration = configuration;
        this.fileSystem = new FileSystemImpl(configuration.directories());
    }

    protected void configure() {
        this.install((Module)new ExtensionModule());
        this.install((Module)new StartUpChecksModule());
        this.install((Module)new StartablesModule());
        this.install((Module)new PreDestroyModule());
        this.install((Module)new DNSServiceModule());
        this.install((Module)new DropWizardMetricsModule());
        this.install((Module)new CleanupTaskModule());
        this.install((Module)new MimeMessageModule());
        this.install((Module)new ClockModule());
        this.install((Module)new PeriodicalHealthChecksModule());
        this.install((Module)new UptrustModule());
        this.bind(FileSystem.class).toInstance((Object)this.fileSystem);
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(ConfigurationProvider.class).toInstance((Object)new FileConfigurationProvider((FileSystem)this.fileSystem, this.configuration));
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(DataProbeImpl.class);
    }

    @Provides
    @Singleton
    public Configuration.ConfigurationPath configurationPath() {
        return this.configuration.configurationPath();
    }

    @Provides
    @Singleton
    public JamesDirectoriesProvider directories() {
        return this.configuration.directories();
    }
}

