/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import javax.mail.Session;
import net.savignano.uptrust.service.IUptrustService;
import net.savignano.uptrust.service.SessionFactory;
import net.savignano.uptrust.service.UptrustService;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.server.core.configuration.ConfigurationProvider;

public class UptrustModule
extends AbstractModule {
    protected void configure() {
        this.bind(Session.class).toProvider(SessionFactory::createSession).in(Scopes.SINGLETON);
    }

    @Singleton
    @Provides
    public IUptrustService uptrustService(ConfigurationProvider configProvider, Session session) {
        try {
            HierarchicalConfiguration uptrustConfig = configProvider.getConfiguration("uptrust");
            return new UptrustService(uptrustConfig, session);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not provide Uptrust service.", e);
        }
    }
}

