/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.File;
import java.util.Optional;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;

public class MemoryJamesConfiguration
implements Configuration {
    private final Configuration.ConfigurationPath configurationPath;
    private final JamesDirectoriesProvider directories;
    private final UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation;

    public static Builder builder() {
        return new Builder();
    }

    public MemoryJamesConfiguration(Configuration.ConfigurationPath configurationPath, JamesDirectoriesProvider directories, UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation) {
        this.configurationPath = configurationPath;
        this.directories = directories;
        this.usersRepositoryImplementation = usersRepositoryImplementation;
    }

    public Configuration.ConfigurationPath configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directories;
    }

    public UsersRepositoryModuleChooser.Implementation getUsersRepositoryImplementation() {
        return this.usersRepositoryImplementation;
    }

    public static class Builder {
        private Optional<String> rootDirectory = Optional.empty();
        private Optional<Configuration.ConfigurationPath> configurationPath = Optional.empty();
        private Optional<UsersRepositoryModuleChooser.Implementation> usersRepositoryImplementation = Optional.empty();

        private Builder() {
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty("working.directory"));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(Configuration.ConfigurationPath path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of(new Configuration.ConfigurationPath("classpath:"));
            return this;
        }

        public Builder usersRepository(UsersRepositoryModuleChooser.Implementation implementation) {
            this.usersRepositoryImplementation = Optional.of(implementation);
            return this;
        }

        public MemoryJamesConfiguration build() {
            Configuration.ConfigurationPath configurationPath = this.configurationPath.orElse(new Configuration.ConfigurationPath("file://conf/"));
            JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
            FileSystemImpl fileSystem = new FileSystemImpl((JamesDirectoriesProvider)directories);
            FileConfigurationProvider configurationProvider = new FileConfigurationProvider((FileSystem)fileSystem, (Configuration)Configuration.Basic.builder().configurationPath(configurationPath).workingDirectory(directories.getRootDirectory()).build());
            UsersRepositoryModuleChooser.Implementation usersRepositoryChoice = this.usersRepositoryImplementation.orElseGet(() -> UsersRepositoryModuleChooser.Implementation.parse((FileConfigurationProvider)configurationProvider));
            return new MemoryJamesConfiguration(configurationPath, (JamesDirectoriesProvider)directories, usersRepositoryChoice);
        }
    }
}

